% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_tune.R
\name{ts_tune}
\alias{ts_tune}
\title{Time Series Tune}
\usage{
ts_tune(input_size, base_model, folds = 10)
}
\arguments{
\item{input_size}{input size for machine learning model}

\item{base_model}{base model for tuning}

\item{folds}{number of folds for cross-validation}
}
\value{
returns a \code{ts_tune} object
}
\description{
Creates a \code{ts_tune} object for tuning hyperparameters of a time series model.
This function sets up a tuning process for the specified base model by exploring different
configurations of hyperparameters using cross-validation.
}
\examples{
data(sin_data)
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

tune <- ts_tune(input_size=c(3:5), base_model = ts_elm(ts_norm_gminmax()))
ranges <- list(nhid = 1:5, actfun=c('purelin'))

# Generic model tunning
model <- fit(tune, x=io_train$input, y=io_train$output, ranges)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
