% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{names.dagitty}
\alias{names.dagitty}
\title{Names of Variables in Graph}
\usage{
\method{names}{dagitty}(x)
}
\arguments{
\item{x}{the input graph, of any type.}
}
\description{
Extracts the variable names from an input graph. Useful for iterating
over all variables.
}
\examples{
## A "DAG" with Romanian and Portuguese variable names. These can be
## input using quotes to overcome the limitations on unquoted identifiers.
g <- dagitty( 'digraph {
  "coração" [pos="0.297,0.502"]
  "inimă" [pos="0.482,0.387"]
  "coração" -> "inimă"
}' )
names( g )
}

