% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqnClass.R
\name{addReaction}
\alias{addReaction}
\title{Add reaction to reaction table}
\usage{
addReaction(eqnlist, from, to, rate, description = names(rate))
}
\arguments{
\item{eqnlist}{equation list, see \link{eqnlist}}

\item{from}{character with the left hand side of the reaction, e.g. "2*A + B"}

\item{to}{character with the right hand side of the reaction, e.g. "C + 2*D"}

\item{rate}{character. The rate associated with the reaction. The name is employed as a description
of the reaction.}

\item{description}{Optional description instead of \code{names(rate)}.}
}
\value{
An object of class \link{eqnlist}.
}
\description{
Add reaction to reaction table
}
\examples{
f <- eqnlist()
f <- addReaction(f, "2*A+B", "C + 2*D", "k1*B*A^2")
f <- addReaction(f, "C + A", "B + A", "k2*C*A")



  # Write your example here. You can also add more Start..End blocks if needed.
  # Please mask all output such as print() with the special tag
  #    
  # such that the test is not littered. Statements guarded by  are enabled
  # in the example file which is extracted from this test file. To extract the
  # example run
  #    extractExamples()
  # on the R command line.
    
    ## Generate another equation list
    eq <- eqnlist()
    eq <- addReaction(eq, "A", "pA", "act_A * A * stimulus", "Phosphorylation of A")
    eq <- addReaction(eq, "pA", "A", "deact_A * pA", "Deposphorylation of pA")
    eq <- addReaction(eq, "2*pA", "pA_pA", "form_complex_pA * pA^2", "Complex formation of pA")
    eq <- addReaction(eq, "B", "pB", "act_B * B * pA_pA", "Phosphorylation of B")
    eq <- addReaction(eq, "pB", "B", "deact_B * pB", "Deposphorylation of pB")
    
    ## Extract data.frame of reactions
    reactions <- getReactions(eq)
     print(reactions)
    
    ## Get conserved quantities
    cq <- conservedQuantities(eq$smatrix)
     print(cq)
    
    ## Get fluxes
    fluxes <- getFluxes(eq)
     print(fluxes)
    
    ## Subsetting of equation list
    subeq1 <- subset(eq, "pB" \%in\% Product)
     print(subeq1)
    subeq2 <- subset(eq, grepl("not_available", Description))
     print(subeq2)
    
    ## Time derivatives of observables
    observables <- eqnvec(pA_obs = "s1*pA", tA_obs = "s2*(A + pA)")
    dobs <- dot(observables, eq)
    
    ## Combined equation vector for ODE and observables
    f <- c(as.eqnvec(eq), dobs)
     print(f)
    
    
  
}
