% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolsMarcus.R
\name{quasiSteadyStates}
\alias{quasiSteadyStates}
\title{Reduce the ODE system by means of a quasi steady-state assumption}
\usage{
quasiSteadyStates(model, fastreact, state2Remove = list(), smatrix = NULL,
  states = NULL, rates = NULL, outputFormat = "R")
}
\arguments{
\item{model}{Either name of the csv-file or the eqnlist of the model. If NULL, specify smatrix, states and rates by hand.}

\item{fastreact}{Character vector, list of flux parameters corresponding to the fast fluxes used for quasi steady-state approximation. 
The ratio between participating fluxes is introduced as a new free parameter.}

\item{state2Remove}{Character, name of state that is expressed by the other states during the simplification}

\item{smatrix}{Numeric matrix, stiochiometry matrix of the system}

\item{states}{Character vector, state vector of the system}

\item{rates}{Character vector, flux vector of the system}

\item{outputFormat}{Define the output format. By default "R" generating dMod 
compatible output. To obtain an output appropriate for d2d [1] "M" must be 
selected (Not yet provided).}
}
\value{
Equation List with reduced model.
}
\description{
Reduce the ODE system by means of a quasi steady-state assumption
}
\author{
Marcus Rosenblatt, \email{marcus.rosenblatt@fdm.uni-freiburg.de}
}
\references{
[1]
\url{https://bitbucket.org/d2d-development/d2d-software/wiki/Home}
}

