% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StoragehubManager.R
\docType{class}
\name{StoragehubManager}
\alias{StoragehubManager}
\title{StoragehubManager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a D4Science StoragehubManager
}
\description{
StoragehubManager
}
\note{
Main user class to be used with \pkg{d4storagehub4R}
}
\section{Methods}{

\describe{
 \item{\code{new(token, logger, keyring_backend)}}{
   This method is used to instantiate the \code{StoragehubManager}. By default,
   the url is inherited through D4Science Icproxy service.
   
   The token is mandatory in order to use Storage Hub API.
   
   The \code{keyring_backend} can be set to use a different backend for storing 
   the D4science gcube token with \pkg{keyring} (Default value is 'env').
   
   The logger can be either NULL, "INFO" (with minimum logs), or "DEBUG" 
   (for complete curl http calls logs)
 }
 \item{\code{getToken()}}{
   Get user token.
 }
 \item{\code{getUserProfile()}}{
   Get user profile.
 }
 \item{\code{getUserWorkspace()}}{
   Get user workspace root path.
 }
 \item{\code{getWSRootID()}}{
   Get workspace root ID
 }
 \item{\code{getWSElementID(parentFolderID, folderPath)}}{
   Get workspace element ID
 }
 \item{\code{listWSElements(parentFolderID)}}{
   Lists workspace elements given a parentFolder ID
 }
 \item{\code{listWSElementsByPath(folderPath)}}{
   Lists workspace elements given a folder path
 }
 \item{\code{searchWSFolderID(folderPath)}}{
   Searchs a folder ID based on folder path
 }
 \item{\code{createFolder(folderPath, name, description, hidden, recursive)}}{
   Creates a folder
 }
 \item{\code{uploadFile(folderPath, file, description, archive)}}{
   Uploads a file
 }
 \item{\code{getPublicFileLink(path)}}{
   Get a public link for a workspace resource
 }
}
}

\examples{
\dontrun{
  manager <- StoragehubManager$new(
    token = "<your token>",
    logger = "DEBUG"
  )
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{manager}
\keyword{storagehub}
