% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxhull.R
\name{plotConvexHull3d}
\alias{plotConvexHull3d}
\title{Plot triangulated 3D convex hull}
\usage{
plotConvexHull3d(
  hull,
  edgesAsTubes = TRUE,
  verticesAsSpheres = TRUE,
  palette = NULL,
  bias = 1,
  interpolate = "linear",
  g = identity,
  facesColor = "navy",
  edgesColor = "gold",
  tubesRadius = 0.03,
  spheresRadius = 0.05,
  spheresColor = edgesColor
)
}
\arguments{
\item{hull}{an output of \code{\link{cxhull}} applied to 3D points and 
with the option \code{triangulate=TRUE}}

\item{edgesAsTubes}{Boolean, whether to draw the edges as tubes}

\item{verticesAsSpheres}{Boolean, whether to draw the vertices as spheres}

\item{palette}{a vector of colors to make a color gradient for the faces; 
if \code{NULL}, the colors of the faces are controlled by the 
\code{facesColor} argument}

\item{bias, interpolate}{if \code{palette} is not \code{NULL}, these arguments are 
passed to \code{\link[grDevices]{colorRamp}}}

\item{g}{a function defined on [0, 1] and taking its values in [0, 1]; it is 
composed with the function created by \code{\link[grDevices]{colorRamp}}, 
based on \code{palette}}

\item{facesColor}{the color(s) for the faces; this argument is ignored if 
the argument \code{palette} is not \code{NULL}; otherwise there are three 
possibilities for \code{facesColor}: 
a single color, a vector of colors with length the number of triangles, 
in which case one color is assigned per triangle, or a vector of colors 
with length the number of faces, after merging the triangles, in 
which case one color is assigned per face; use \code{\link{hullSummary}} 
to know the number of faces}

\item{edgesColor}{the color for the edges}

\item{tubesRadius}{the radius of the tubes when \code{edgesAsTubes=TRUE}}

\item{spheresRadius}{the radius of the spheres when 
\code{verticesAsSpheres=TRUE}}

\item{spheresColor}{the color of the spheres when 
\code{verticesAsSpheres=TRUE}}
}
\value{
No value.
}
\description{
Plot a triangulated 3D convex hull with \strong{rgl}.
}
\examples{
library(cxhull)
library(rgl)
dodecahedron <- t(dodecahedron3d()$vb[-4L, ])
hull <- cxhull(dodecahedron, triangulate = TRUE)
# single color ####
open3d(windowRect = c(50, 50, 562, 562))
plotConvexHull3d(hull)
# gradient ####
open3d(windowRect = c(50, 50, 562, 562))
plotConvexHull3d(hull, palette = hcl.colors(256, "Rocket"), bias = 0.5)
}
