% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{model_functions}
\alias{model_functions}
\title{Examples of model_fn functions}
\usage{
model_functions(name)
}
\arguments{
\item{name}{Name of model to get model function for,
 as it appears in the following list:

 \tabular{rrr}{
  \strong{Name} \tab \strong{Function} \tab \strong{Hyperparameters (default)} \cr
  "lm" \tab \code{\link[stats:lm]{stats::lm()}} \tab \cr
  "lmer" \tab \code{\link[lme4:lmer]{lme4::lmer()}} \tab \code{REML (FALSE)} \cr
  "glm_binomial" \tab \code{\link[stats:lm]{stats::glm()}} \tab \cr
  "glmer_binomial" \tab \code{\link[lme4:glmer]{lme4::glmer()}} \tab \cr
  "svm_gaussian" \tab \code{\link[e1071:svm]{e1071::svm()}} \tab \code{kernel ("radial")}, \code{cost (1)}\cr
  "svm_binomial" \tab \code{\link[e1071:svm]{e1071::svm()}} \tab \code{kernel ("radial")}, \code{cost (1)}\cr
  "svm_multinomial" \tab \code{\link[e1071:svm]{e1071::svm()}} \tab \code{kernel ("radial")}, \code{cost (1)}\cr
  "naive_bayes" \tab \code{\link[e1071:naiveBayes]{e1071::naiveBayes()}} \tab \code{laplace (0)} \cr
  }}
}
\value{
A function with the following form:

 \code{function(train_data, formula, hyperparameters) \{}

 \verb{    }\code{# Return fitted model object}

 \code{\}}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Examples of model functions that can be used in
 \code{\link[cvms:cross_validate_fn]{cross_validate_fn()}}.
 They can either be used directly or be starting points.

 The \code{\link[cvms:update_hyperparameters]{update_hyperparameters()}} function
 updates the list of hyperparameters with default values for missing hyperparameters.
 You can also specify required hyperparameters.
}
\seealso{
Other example functions: 
\code{\link{predict_functions}()},
\code{\link{preprocess_functions}()},
\code{\link{update_hyperparameters}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{example functions}
