% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cptest.R
\name{cptest}
\alias{cptest}
\title{Clustered permutation test for cluster randomized trials}
\usage{
cptest(outcome, id, x, cspacedatname, outcometype, categorical = NULL)
}
\arguments{
\item{outcome}{a vector specifying the individual outcome}

\item{id}{a vector specifying cluster name}

\item{x}{a matrix or a data frame specifying the individual-level covariates to analyze}

\item{cspacedatname}{the csv dataset containing the saved randomization space. This dataset contains the permutation matrix, as well as a variable indicating which row of the permutation matrix was saved as the final schemes.}

\item{outcometype}{the type of regression model that should be run. Options are "continuous" for linear regression fit and "binary" for logistic regression fit.}

\item{categorical}{a vector specifying categorical (including binary) variables. This can be names of the columns or numbers of indexes of columns)}
}
\value{
\code{FinalScheme} the final scheme in the permutation matrix

\code{pvalue} the p-value of the intervention effect from the clustered permutation test

\code{pvalue_statement} the statement of the p-value of the intervention effect from the clustered permutation test
}
\description{
cptest performs clustered permutation test on the individual oucome for cluster
randomized trials (CRTs). The type of the outcome can be specified by the user to be "continuous" or
"binary".

With specified outcome type being "continuous" or "binary", linear regression or logistic regression is applied on the outcome and the covariates specified for all individuals. Cluster residual means are collected. With the constrained space,
the contrast statistic is created from the schemes and the cluster residual means. The permutation test is then conducted on the contrast statistic for the scheme actually utilized.
}
\examples{
\dontrun{
Analysis_result <- cptest(outcome = Dickinson_outcome$outcome,
                          id = Dickinson_outcome$county,
                          x = data.frame(Dickinson_outcome[, c(-1, -7)]),
                          cspacedatname="dickinson_constrained.csv",
                          outcometype="binary",
                          categorical=c("location","incomecat"))
}

}
\references{
Gail, M.H., Mark, S.D., Carroll, R.J., Green, S.B. and Pee, D., 1996. On design considerations and randomization based inference for community intervention trials. Statistics in medicine, 15(11), pp.1069-1092.

Li, F., Lokhnygina, Y., Murray, D.M., Heagerty, P.J. and DeLong, E.R., 2016. An evaluation of constrained randomization for the design and analysis of group randomized trials. Statistics in medicine, 35(10), pp.1565-1579.
}
\author{
Hengshi Yu <hengshi@umich.edu>, John A. Gallis <john.gallis@duke.edu>, Fan Li <frank.li@duke.edu>, Elizabeth L. Turner <liz.turner@duke.edu>
}
\keyword{cluster}
\keyword{clustered}
\keyword{permutation}
\keyword{randomized}
\keyword{test,}
\keyword{trails}
