% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-algae.R
\name{Algae_Weber}
\alias{Algae_Weber}
\alias{AlgaeWeber-class}
\alias{AlgaeWeberScenario-class}
\title{Algae model with exponential growth and forcings (I, T)}
\usage{
Algae_Weber()
}
\value{
an S4 object of type \linkS4class{AlgaeWeber}
}
\description{
The model is a mechanistic combined toxicokinetic-toxicodynamic (TK/TD) and
growth model for algae. The model simulates the development of algal biomass
under laboratory and environmental conditions and was developed by
Weber et al. (2012) as cited in EFSA TKTD opinion (2018). The growth of the
algae population is simulated on the basis of growth rates, which are
dependent on environmental conditions (radiation, temperature and phosphorus).
The toxicodynamic sub-model describes the effects of growth-inhibiting
substances through a corresponding reduction in the photosynthesis rate on
the basis of internal concentrations. (the implementation of Weber et al.
(2012) is followed where units differ with EFSA)
}
\section{State variables}{

The model has four state variables:
\itemize{
\item \code{A}, Biomass (ug fresh wt/mL, cells/mL *10^4)
\item \code{Q}, Mass of phosphorous internal (mg P/L, or ug P/mL)
\item \code{P}, Mass of phosphorous external (mg P/L, or ug P/mL)
\item \code{C}, external substance concentration (ug/L)
}
}

\section{Model parameters}{

\itemize{
\item Growth model
\itemize{
\item \code{mu_max}, Maximum growth rate (d-1)
\item \code{Q_min}, Minimum intracellular P (ug P/ug fresh wt)
\item \code{Q_max}, Maximum intracellular P (ug P/ug fresh wt)
\item \code{v_max}, Maximum P-uptake rate at non-limited growth (ug P/ug fresh wt/d)
\item \code{k_s},   Half-saturation constant for extracellular P (mg P/L)
\item \code{m_max}, Natural mortality rate (1/d)
\item \code{I_opt}, Optimum light intensity for growth (uE/m²/s)
\item \code{T_opt}, Optimum temperature for growth (°C)
\item \code{T_max}, Maximum temperature for growth (°C)
\item \code{T_min}, Minimum temperature for growth (°C)
\item \code{D}, Dilution rate (1/d)
\item \code{R_0}, Influx concentration of P (mg P/L)
}
\item Concentration response (Toxicodynamics)
\itemize{
\item \code{EC_50}, Effect concentration of 50\% inhibition of growth rate (ug/L)
\item \code{b}, slope of concentration effect curve at EC_50 (-)
}
\item External concentration (Toxicokinetics)
\itemize{
\item \code{k}, Degradation rate of toxicant in aquatic environments (d-1)
}
}
}

\section{Forcings}{

Besides exposure events (C_in), the \emph{Algae} model requires three environmental
properties as time-series input: Irradiance (\code{I}, uE/m²/s)
and temperature (\code{T_act}, deg C).
Forcings time-series are represented by \code{data.frame} objects
consisting of two columns. The first for time and the second for the
environmental factor in question. The input format for all forcings is a
list of the data frames.
}

\section{Simulation output}{

Simulation results will contain the state variables Biomass (\code{A}), mass of
internal phosphorous (\code{Q}), mass of external phosphorous (\code{P}) and the external
concentration (\code{C}).

It is possible to amend the output of \code{\link[=simulate]{simulate()}} with additional model
quantities that are not state variables, for e.g. debugging purposes or to
analyze model behavior. To enable or disable additional outputs, use the
optional argument \code{nout} of \code{\link[=simulate]{simulate()}}. As an example, set \code{nout=2} to
enable reporting of model derivatives \code{dA} and \code{dQ}. Set \code{nout=0} to disable
additional outputs (default).

The available output levels are as follows:
\itemize{
\item Derivatives
\itemize{
\item \code{nout >= 1}: \code{dA}, biomass derivative (µg)
\item \code{nout >= 2}: \code{dQ}, internal phosphorous derivative (mg P/ug fresh wt)
\item \code{nout >= 3}: \code{dP}, external phosphorous derivative (mg P L-1)
\item \code{nout >= 4}: \code{dC}, external concentration derivative (ug L-1)
}
}
}

\section{Parameter boundaries}{

Default values for parameter boundaries are set for all parameters by expert
judgement, for calibration purposes. Values can be access from the object, and
defaults overwritten.
}

\references{
Weber D, Schaeffer D, Dorgerloh M, Bruns E, Goerlitz G, Hammel K, Preuss TG
and Ratte HT, 2012. Combination of a higher-tier flow-through system and
population modeling to assess the effects of time-variable exposure of
isoproturon on the green algae Desmodesmus subspictatus and
Pseudokirchneriella subcapitata. Environmental Toxicology and
Chemistry, 31, 899-908. \doi{10.1002/etc.1765}

EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, Brock T, Duquesne S, Grilli S,
Hernandez-Jerez AF, Bennekou SH,Klein M, Kuhl T, Laskowski R, Machera K,
Pelkonen O, Pieper S, Smith RH, Stemmer M, Sundh I, Tiktak A,Topping CJ,
Wolterink G, Cedergreen N, Charles S, Focks A, Reed M, Arena M, Ippolito A,
Byers H andTeodorovic I, 2018. Scientific Opinion on the state of the art of
Toxicokinetic/Toxicodynamic (TKTD)effect models for regulatory risk assessment
of pesticides for aquatic organisms. EFSA Journal, 16(8), 5377.
\doi{10.2903/j.efsa.2018.5377}
}
\seealso{
\link{Scenarios}, \link{Transferable}

Other algae models: 
\code{\link{Algae-models}},
\code{\link{Algae_Simple}()},
\code{\link{Algae_TKTD}()}
}
\concept{algae models}
