% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-GutsRed.R
\name{GUTS_RED_IT}
\alias{GUTS_RED_IT}
\alias{GutsRedIt-class}
\title{GUTS-RED-IT scenario}
\usage{
GUTS_RED_IT(param, init)
}
\arguments{
\item{param}{optional named \code{list} or \code{vector} with model parameters}

\item{init}{optional named numeric \code{vector} to use as initial state}
}
\value{
an S4 object of type \linkS4class{GutsRedIt}
}
\description{
Reduced \emph{General Unified Threshold models of Survival} (GUTS) with
individual tolerance (\emph{IT}).
}
\section{State variables}{

The following list describes the default names and standard units of \emph{GUTS-RED}
state variables:
\itemize{
\item \code{D}, scaled damage (conc)
\item \code{H}, cumulative hazard (-)
}

The state variables are initialized with zero by default.
}

\section{IT model parameters}{

\itemize{
\item \code{kd}, dominant rate constant (time^-1)
\item \code{hb}, background hazard rate (time^-1)
\item \code{alpha}, median of thresholds (conc)
\item \code{beta}, shape parameter (-)
}
}

\section{Effects}{

The effect endpoint \code{L} (lethality) is available for \emph{GUTS-RED} models.
A value of zero (\code{0.0}) denotes \emph{no effect} on organism survival. A value of
one (\code{1.0}) denotes a lethality rate of 100\%, i.e. no survivors.

In addition, the surival rate over time can be derived for all output time
points using \code{\link[=survival]{survival()}}.
}

\references{
EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, et al., 2018: \emph{Scientific Opinion on the
state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect models for
regulatory risk assessment of pesticides for aquatic organisms}. EFSA Journal 2018;
16(8):5377, 188 pp. \doi{10.2903/j.efsa.2018.5377}
}
\seealso{
Other GUTS-RED models: 
\code{\link{GUTS-RED-models}},
\code{\link{GUTS_RED_SD}()}
}
\concept{GUTS-RED models}
