% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum_limit_exact.R
\name{cusum_limit_exact}
\alias{cusum_limit_exact}
\title{Calculate exact control limit given false signal probability alpha for CUSUM charts for very small sample sizes}
\usage{
cusum_limit_exact(n_patients, failure_probability, odds_multiplier, alpha)
}
\arguments{
\item{n_patients}{Integer. Number of patients in monitoring period /sample size}

\item{failure_probability}{Double. Baseline failure probability}

\item{odds_multiplier}{Double. Odds multiplier of adverse event under the alternative hypothesis (<1 looks for decreases)}

\item{alpha}{Double. False signal probability of CUSUM}
}
\value{
Returns the control limit for signalling performance change for small sample sizes (double)
}
\description{
This function only works for very small sample sizes (<= 15),
as it permutes through all possible outcome sequences and estimates the percentage of runs that reach a specific CUSUM values.
}
\examples{

# calculate exact control limits for alpha = 0.05
cusum_limit_exact(
  failure_probability = 0.1,
  n_patients = 10,
  odds_multiplier = 2,
  alpha = 0.05
)
}
