% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_headers.R
\name{parse_headers}
\alias{parse_headers}
\title{Parse response headers}
\usage{
parse_headers(txt, multiple = FALSE)
}
\arguments{
\item{txt}{raw or character vector with the header data}

\item{multiple}{parse multiple sets of headers separated by a blank line. See details.}
}
\description{
Parse response header data as returned by curl_fetch If the request has
followed redirects, the data can contain multiple sets of headers. Therefore
when multiple = TRUE, the function returns a list with the response headers
for each request. By default it only returns the headers of the final request.
}
\examples{
req <- curl_fetch_memory("https://httpbin.org/redirect/3")
parse_headers(req$headers)
parse_headers(req$headers, multiple = TRUE)
}
