% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.curesurv.R
\name{anova.curesurv}
\alias{anova.curesurv}
\title{anova.curesurv function for likelihood-ratio test of two nested models from curesurv function}
\usage{
\method{anova}{curesurv}(object, ..., test = "LRT")
}
\arguments{
\item{object}{An object of class curesurv.}

\item{...}{Additional object of class curesurv.}

\item{test}{A character string. Computes the likelihood-ratio test for value \code{"LRT"}. In case the two models are the same, but one with the correction of mortality tables and one without, the likelihood ratio test is computed for value \code{"LRT_alpha"}  These are the only tests available for now.}
}
\value{
An object of class anova inheriting from class matrix. The different columns contain respectively the degrees of freedom and the log-likelihood values of the two nested models, the degree of freedom of the chi-square statistic, the chi-square statistic, and the p-value of the likelihood ratio test.
}
\description{
This function computes an analysis of deviance table for two excess hazard models fitted using the curesurv R package.
}
\note{
The comparison between two or more models by anova or more excess hazard models will only be valid if they are fitted to the same dataset, and if the compared models are nested. This may be a problem if there are missing values.
}
\examples{
\donttest{
library("curesurv")
library("survival")

testiscancer$age_crmin <- (testiscancer$age - min(testiscancer$age)) / sd(testiscancer$age)

fit_m0 <- curesurv(Surv(time_obs, event) ~ 1 | 1,
                          pophaz = "ehazard",
                          cumpophaz = "cumehazard",
                          model = "nmixture", dist = "tneh",
                          link_tau = "linear",
                          data = testiscancer,
                          method_opt = "L-BFGS-B")

fit_m1 <- curesurv(Surv(time_obs, event) ~ age_crmin | 1,
                          pophaz = "ehazard",
                          cumpophaz = "cumehazard",
                          model = "nmixture", dist = "tneh",
                          link_tau = "linear",
                          data = testiscancer,
                          method_opt = "L-BFGS-B")

anova(fit_m0, fit_m1)
}

}
