% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{cuml_kmeans}
\alias{cuml_kmeans}
\title{Run the K means clustering algorithm.}
\usage{
cuml_kmeans(x, k, max_iters = 300)
}
\arguments{
\item{x}{The input matrix or dataframe. Each data point should be a row
and should consist of numeric values only.}

\item{k}{The number of clusters.}

\item{max_iters}{Maximum number of iterations (default: 300).}
}
\value{
A list containing the cluster assignments and the centroid of each
  cluster. Each centroid will be a column within the `centroids` matrix.
}
\description{
Run the K means clustering algorithm.
}
\examples{

library(cuml4r)

kclust <- cuml_kmeans(
  iris[, which(names(iris) != "Species")],
  k = 3,
  max_iters = 100
)

print(kclust)
}
