% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbscan.R
\name{cuml_dbscan}
\alias{cuml_dbscan}
\title{Run the DBSCAN clustering algorithm.}
\usage{
cuml_dbscan(
  x,
  min_pts,
  eps,
  cuml_log_level = c("off", "critical", "error", "warn", "info", "debug", "trace")
)
}
\arguments{
\item{x}{The input matrix or dataframe. Each data point should be a row
and should consist of numeric values only.}

\item{min_pts, eps}{A point `p` is a core point if at least `min_pts` are
within distance `eps` from it.}

\item{cuml_log_level}{Log level within cuML library functions. Must be one of
{"off", "critical", "error", "warn", "info", "debug", "trace"}.
Default: off.}
}
\value{
A list containing the cluster assignments of all data points. A data
 point not belonging to any cluster (i.e., "noise") will have NA its cluster
 assignment.
}
\description{
Run the DBSCAN (Density-based spatial clustering of applications with noise)
clustering algorithm.
}
\examples{
library(cuml)
library(magrittr)

gen_pts <- function() {
  centroids <- list(c(1000, 1000), c(-1000, -1000), c(-1000, 1000))

  pts <- centroids \%>\%
    purrr::map(
      ~ MASS::mvrnorm(10, mu = .x, Sigma = matrix(c(1, 0, 0, 1), nrow = 2))
    )

  rlang::exec(rbind, !!!pts)
}

m <- gen_pts()
clusters <- cuml_dbscan(m, min_pts = 5, eps = 3)

print(clusters)
}
