% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cuRe.R
\name{plot.cuRe}
\alias{plot.cuRe}
\title{Plot function for Flexible mixture cure model}
\usage{
\method{plot}{cuRe}(x, newdata = NULL,
        type = c("surv", "probcure", "survuncured", "hazarduncured", "cumhazuncured",
        "densityuncured", "failuncured", "oddsuncured", "loghazarduncured", "hazard",
        "density", "fail", "loghazard", "odds", "cumhaz"), time = NULL, xlim = NULL,
        ylim = c(0, 1), xlab = "Time", ylab = NULL, col = 1, ci = T, add = F, \dots)
}
\arguments{
\item{x}{Object of class \code{cuRe}.}

\item{newdata}{Data frame from which to compute predictions. If empty, predictions are made on the the data which
the model was fitted on.}

\item{type}{Character. Defines the desired scale to plot. See ?predict.gfcm for possible values.}

\item{time}{Optional time points at which to compute predictions.
This argument is not used if type is \code{curerate}.}

\item{xlim}{Limits of the x-axis}

\item{ylim}{Limits of the y-axis.}

\item{xlab}{Label of the x-axis. Default is "Time".}

\item{ylab}{Label of the y-axis. If \code{NULL}, the function uses its default y-labels
depending on \code{object$type} and \code{object$excess}.}

\item{col}{Colour of each line.}

\item{ci}{Logical. If \code{TRUE} (default), confidence intervals are added to the plot.}

\item{add}{Loglca. If \code{TRUE} the curve is added to the existing plot.}

\item{...}{Further arguments passed to \code{plot} and \code{lines}.}
}
\value{
A plot containing the predictions of each observation in \code{newdata}.
}
\description{
Plot function associated with the classes \code{gfcm} and \code{cm}
}
