% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endian.R
\name{flip_endian}
\alias{flip_endian}
\title{Flip the endianness of elements in a vector}
\usage{
flip_endian(x, size)
}
\arguments{
\item{x}{vector. Usually a raw vector, but can be any type}

\item{size}{block size. Usually a power of 2.}
}
\value{
A vector of the same type as the initial vector with the values
        within each block reversed.
}
\description{
This will create a new vector with the values reversed within the given 
block size. This can be used for changing the endianness of a set of values
}
\examples{
vec <- c(1, 2, 3, 4)
flip_endian(vec, 1)   # should give: c(1, 2, 3, 4)
flip_endian(vec, 2)   # should give: c(2, 1, 4, 3)
flip_endian(vec, 4)   # should give: c(4, 3, 2, 1)
}
\seealso{
Other data permutation functions: 
\code{\link{aperm_array_to_vector}()},
\code{\link{aperm_vector_to_array}()}
}
\concept{data permutation functions}
