% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDiscretePars.R
\name{ctDiscretePars}
\alias{ctDiscretePars}
\title{ctDiscretePars}
\usage{
ctDiscretePars(ctpars, times = seq(0, 10, 0.1), type = "all")
}
\arguments{
\item{ctpars}{List of continuous time parameter matrices.}

\item{times}{Numeric vector of positive values, discrete time parameters will be calculated for each.}

\item{type}{String. 'all' returns all possible outputs in a list. 
'discreteDRIFT' returns only discrete time auto and cross regression effects.
'latentMeans' returns only the expected latent means, given initial (T0MEANS) level, 
latent intercept (CINT) and temporal effects (DRIFT).}
}
\description{
Generate discrete time parameters for a sequence of times based on a list containing coninuous time
parameter matrices as used in ctsem.
}
\examples{
\donttest{
pars <- ctStanContinuousPars(ctstantestfit)
ctDiscretePars(pars,times=c(.5,1))
}

}
