% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctCheckFit.R
\name{ctCheckFit}
\alias{ctCheckFit}
\title{Check absolute fit of ctFit or ctStanFit object.}
\usage{
ctCheckFit(fit, niter = 500, probs = c(0.025, 0.5, 0.975))
}
\arguments{
\item{fit}{ctFit or ctStanFit object.}

\item{niter}{number of data generation iterations to use to calculate quantiles.}

\item{probs}{3 digit vector of quantiles to return and to test significance.}
}
\value{
List containing a means and cov object, computed by sorting data into discrete time points.
cov is a numeric matrix containing measures of the covariance matrices for observed and simulated data. 
The MisspecRatio column shows Z score difference for each lower triangular index of the covariance matrix of data --
observed covariance minus mean of generated, weighted by sd of generated covariance.
means contains the empirical and generated data means.
}
\description{
Check absolute fit of ctFit or ctStanFit object.
}
\details{
for plotting help see \code{\link{plot.ctsemFitMeasure}}
}
\examples{
\donttest{
data(ctExample1)
traitmodel <- ctModel(n.manifest=2, n.latent=2, Tpoints=6, LAMBDA=diag(2), 
  manifestNames=c('LeisureTime', 'Happiness'), 
  latentNames=c('LeisureTime', 'Happiness'), TRAITVAR="auto")
traitfit <- ctFit(dat=ctExample1, ctmodelobj=traitmodel)

check <- ctCheckFit(traitfit,niter=5)
plot(check)
}
}
