% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctsem.R
\docType{package}
\name{ctsem}
\alias{ctsem}
\alias{ctsem-package}
\title{ctsem}
\description{
ctsem is an R package for continuous time structural equation modelling of panel (N > 1) 
and time series (N = 1) data, using either a frequentist or Bayesian approach. 
The frequentist approach is faster but can only estimate random-effects on the intercepts, 
while the Bayesian approach allows for random-effects across all model parameters.
}
\details{
The general workflow begins by specifying a model using the \code{\link{ctModel}} function, 
in which the \code{type} of model is also specified. Then the model is fit to data using 
either \code{\link{ctFit}} if an 'omx' (OpenMx, frequentist) model is specified or 
\code{\link{ctStanFit}} if a 'stanct' or 'standt' (Stan, continuous / discrete time, Bayesian)
model is specified. 
For examples, see either \code{\link{ctFit}} or \code{\link{ctStanFit}}. 
For more detailed information, see the frequentist vignette by running: \code{vignette('ctsem')} 
For citation info, please run \code{citation('ctsem')} .
}
\references{
https://www.jstatsoft.org/article/view/v077i05

Driver, C. C., & Voelkle, M. C. (2018). Hierarchical Bayesian continuous time dynamic modeling. 
Psychological Methods. Advance online publication.http://dx.doi.org/10.1037/met0000168

Stan Development Team (2018). RStan: the R interface to Stan. R package version 2.17.3. http://mc-stan.org
}
