newkalman <- function(fit){
  if(1==0){
    k=extract.ctStanFit(fit)$kalman
    k[k==99999] <- NA #for missingness
    nlatent <- fit$standata$nlatentpop
    nmanifest <- fit$standata$nmanifest
    dimnames(k) = list(iter=1:dim(k)[1],drow=1:dim(k)[2],
      kalman=paste0(c(rep('lln',nmanifest),
        rep('llscale',nmanifest),rep('err',nmanifest),rep('ypred',nmanifest),rep('etaprior',nlatent),rep('etaupd',nlatent)),
        c(1:nmanifest,1:nmanifest,1:nmanifest,1:nmanifest,1:nlatent,1:nlatent)))
    

    
    obj <- c('lln','llscale','err','ypred','etaprior','etaupd')
    
    
    lln=k[,,1:nmanifest,drop=FALSE]
    llscale=k[,,(nmanifest*1+1):(nmanifest*1+nmanifest),drop=FALSE]
    err=k[,,(nmanifest*2+1):(nmanifest*2+nmanifest),drop=FALSE]
    ypred=k[,,(nmanifest*3+1):(nmanifest*3+nmanifest),drop=FALSE]
    etaprior=k[,,(nmanifest*4+1):(nmanifest*4+nlatent),drop=FALSE]
    etaupd=k[,,(nmanifest*4+nlatent+1):(nmanifest*4+nlatent*2),drop=FALSE]
    
    plot(ypred[1,,2], err[1,,2]) #first iteration, all time points, 2nd indicator variable
    plot(err[1,,1])
    df=data.frame(c(err),c(etaprior))
    colnames(df)=c('err','etaprior')
    lm(err ~ etaprior,data = df)
  } 
}


  
