% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_externalLinks.R
\name{f.externalLinks}
\alias{f.externalLinks}
\title{Calculate the external references from a study's register record}
\usage{
f.externalLinks(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and new column `.externalLinks`
(character).
}
\description{
Trial concept calculated: Calculates the links e.g. to publications or
other external files referenced from a study record.
Requires loading results-related information for EUCTR.
Note that documents stored in registers can be downloaded directly,
see \link{ctrLoadQueryIntoDb}.
}
\examples{
# fields needed
f.hasResults()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.externalLinks",
  con = dbc)
trialsDf

}
