% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nor_locations_hierarchy.R
\name{nor_locations_hierarchy_from_to}
\alias{nor_locations_hierarchy_from_to}
\title{Location hierarchies in Norway}
\usage{
nor_locations_hierarchy_from_to(
  from,
  to,
  include_to_name = FALSE,
  border = csdata::config$border_nor
)
}
\arguments{
\item{from}{wardoslo, wardbergen, wardtrondheim, wardstavanger, municip, baregion, county, georegion, mtregion, notmainlandmunicip, notmainlandcounty, missingmunicip, missingcounty}

\item{to}{wardoslo, wardbergen, wardtrondheim, wardstavanger, municip, baregion, county, georegion, mtregion, notmainlandmunicip, notmainlandcounty, missingmunicip, missingcounty}

\item{include_to_name}{Do you want to include the name of the 'to' location?}

\item{border}{The year in which Norwegian geographical boundaries were designated (2020, 2024).}
}
\value{
Data.table containing the columns:
\itemize{
\item from_code
\item to_code
\item to_name (if include_to_name==TRUE)
}
}
\description{
Calculates the relationship between different locations in Norway, according
to geographic granularity. For example, which municipalities are inside which counties.
}
\examples{
csdata::nor_locations_hierarchy_from_to(from="wardoslo", to="county")
csdata::nor_locations_hierarchy_from_to(from="municip", to="baregion")
}
