% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getQuote.R
\name{getQuote}
\alias{getQuote}
\title{Get a quote on a cryptopair from one
of the supported exchanges}
\usage{
getQuote(
 ticker,
 source   = 'binance',
 futures  = TRUE,
 interval = '1d',
 from     = NULL,
 to       = NULL
)
}
\arguments{
\item{ticker}{A character vector of length 1. Uppercase. See \code{\link[=availableTickers]{availableTickers()}} for available tickers.}

\item{source}{A character vector of length 1. See \code{\link[=availableExchanges]{availableExchanges()}} for available exchanges.}

\item{futures}{A logical value. Returns futures market if \link{TRUE}, spot market otherwise.}

\item{interval}{A character vector of length 1. See \code{\link[=availableIntervals]{availableIntervals()}} for available intervals.}

\item{from}{An optional vector of length 1. Can be \code{\link[=Sys.Date]{Sys.Date()}}-class, \code{\link[=Sys.time]{Sys.time()}}-class or \code{\link[=as.character]{as.character()}} in \%Y-\%m-\%d format.}

\item{to}{An optional vector of length 1. Can be \code{\link[=Sys.Date]{Sys.Date()}}-class, \code{\link[=Sys.time]{Sys.time()}}-class or \code{\link[=as.character]{as.character()}} in \%Y-\%m-\%d format.}
}
\value{
an xts object with Open, High, Low, Close and Volume. If \code{futures = TRUE} the prices are last prices.
}
\description{
Open, High, Low, Close, and Volume (OHLCV) quotes are essential pieces of
information used to analyze the price and trading activity of a financial asset over a specific time frame.
}
\details{
If only \code{from} is provided 100 pips are returned up to \code{Sys.time()}.

If only \code{to} is provided 100 pips up to the specified date
is returned.

If \code{from} and \code{to} are both \link{NULL} 100 pips returned up to \code{Sys.time()}
}
\examples{
# 1) Load BTC spot
# from Kucoin with 30 minute
# intervals
BTC <- try(
  cryptoQuotes::getQuote(
    ticker   = 'BTC-USDT',
    source   = 'kucoin',
    interval = '30m',
    futures  = FALSE,
    from     = Sys.Date() - 1
  )
)

# 2) chart the spot price
# using the chart
# function
if (!inherits(BTC, 'try-error')){

  cryptoQuotes::chart(
    chart = cryptoQuotes::kline(BTC) \%>\%
      cryptoQuotes::addVolume() \%>\%
      cryptoQuotes::addBBands()
  )

}

# script end;
}
