% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_listings.R
\name{crypto_listings}
\alias{crypto_listings}
\title{Retrieves name, CMC id, symbol, slug, rank, an activity flag as well as activity dates on CMC for all coins}
\usage{
crypto_listings(
  which = "latest",
  convert = "USD",
  limit = 5000,
  start_date = NULL,
  end_date = NULL,
  interval = "day",
  quote = FALSE,
  sleep = 60,
  finalWait = TRUE
)
}
\arguments{
\item{which}{string Shall the code retrieve the latest listing, the new listings or a historic listing?}

\item{convert}{string (default: USD) to one or more of available fiat or precious metals prices (\code{fiat_list()}). If more
than one are selected please separate by comma (e.g. "USD,BTC"), only necessary if 'quote=TRUE'}

\item{limit}{integer Return the top n records, default is 5000 (max allowed by CMC)}

\item{start_date}{string Start date to retrieve data from, format 'yyyymmdd'}

\item{end_date}{string End date to retrieve data from, format 'yyyymmdd', if not provided, today will be assumed}

\item{interval}{string Interval with which to sample data according to what \code{seq()} needs}

\item{quote}{logical set to TRUE if you want to include price data (FALSE=default)}

\item{sleep}{integer (default 60) Seconds to sleep between API requests}

\item{finalWait}{to avoid calling the web-api again with another command before 60s are over (TRUE=default)}
}
\value{
List of latest/new/historic listings of cryptocurrencies in a tibble (depending on the "which"-switch and
whether "quote" is requested, the result may only contain some of the following variables):
\item{id}{CMC id (unique identifier)}
\item{name}{Coin name}
\item{symbol}{Coin symbol (not-unique)}
\item{slug}{Coin URL slug (unique)}
\item{date_added}{Date when the coin was added to the dataset}
\item{last_updated}{Last update of the data in the database}
\item{rank}{Current rank on CMC (if still active)}
\item{market_cap}{market cap - close x circulating supply}
\item{market_cap_by_total_supply}{market cap - close x total supply}
\item{market_cap_dominance}{market cap dominance}
\item{fully_diluted_market_cap}{fully diluted market cap}
\item{self_reported_market_cap}{is the source of the market cap self-reported}
\item{self_reported_circulating_supply}{is the source of the circulating supply self-reported}
\item{tvl_ratio}{percentage of total value locked}
\item{price}{latest average price}
\item{circulating_supply}{approx. number of coins in circulation}
\item{total_supply}{approx. total amount of coins in existence right now (minus any coins that have been verifiably burned)}
\item{max_supply}{CMC approx. of max amount of coins that will ever exist in the lifetime of the currency}
\item{num_market_pairs}{number of market pairs across all exchanges this coin}
\item{tvl}{total value locked}
\item{volume_24h}{Volume 24 hours}
\item{volume_change_24h}{Volume change in 24 hours}
\item{percent_change_1h}{1 hour return}
\item{percent_change_24h}{24 hour return}
\item{percent_change_7d}{7 day return}
}
\description{
This code uses the web api. It retrieves listing data (latest/new/historic) and does not require an 'API' key.
}
\examples{
\dontrun{
# return new listings from the last 30 days
new_listings <- crypto_listings(which="new", quote=FALSE)
new_listings2 <- crypto_listings(which="new", quote=TRUE, convert="BTC,USD")
# return latest listing (last available data of all CC including quotes)
latest_listings <- crypto_listings(which="latest", quote=TRUE)

# return all listings in the first week of January 2014
listings_2014w1 <- crypto_listings(which="historical", quote=TRUE,
start_date = "20140101", end_date="20140107", interval="day")

# report in two different currencies
listings_2014w1_USDBTC <- crypto_listings(which="historical", quote=TRUE,
start_date = "20140101", end_date="20140107", interval="day", convert="USD,BTC")
}

}
