% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflections_S3.R
\name{create_merged_reflections.default}
\alias{create_merged_reflections.default}
\title{Default method for generic "create_merged_reflections"}
\usage{
\method{create_merged_reflections}{default}(
  ruc = NULL,
  csym = NULL,
  records = NULL,
  dtypes = NULL,
  ...
)
}
\arguments{
\item{ruc}{An object of class 'rec_unit_cell'.}

\item{csym}{An object of class 'cryst_symm'.}

\item{records}{A data frame containing all reflections coming
from the x-ray data collection on the crystal. This
data frame must include at least the three Miller
indices, H, K, L (of dtype "H").}

\item{dtypes}{A character vector whose length is the same as
the number of columns in 'records'. One character (a
capital letter) is associated with each type of data.
For example, a Miller index is of dtype "H"; a structure
amplitude is of dtype "F"; an anomalous difference is of
dtype "D"; etc (see details later).}

\item{...}{Additional arguments passed to the
create_merged_reflections methods.}
}
\value{
An object of class "merged_reflections". It is a named
        list of length 4 whose names are:
        \describe{
          \item{ruc}{An object of class "rec_unit_cell".}
          \item{csym}{An object of class "cryst_symm".}
          \item{records}{A data frame containing the data.}
          \item{dtypes}{A character vector containing the
                type of data (Miller indices, structure
                factors, etc).}
        }
}
\description{
This method is an alternative call to 'merged_reflections'.
.
}
\examples{
# Create merged data for a cubic (10 angstrom) unit cell
# of space group P 2 3. Data up to 5 angstroms resolution
mrefs <- create_merged_reflections()
print(mrefs)

}
\seealso{
\code{\link{merged_reflections}}
}
