% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new-dataset.R
\name{shojifyDatasetMetadata}
\alias{shojifyDatasetMetadata}
\title{Wrap variable metadata inside a dataset entity}
\usage{
shojifyDatasetMetadata(
  metadata,
  order = I(names(metadata)),
  ...,
  project = defaultCrunchProject()
)
}
\arguments{
\item{metadata}{list of variable metadata}

\item{order}{a valid "order" payload: list containing either aliases or
list(group, entities)}

\item{...}{dataset entity metadata. "name" is required.}

\item{project}{A \code{ProjectFolder} object, string path that could be passed to \code{\link[=cd]{cd()}}
relative to the root project, or a URL for a \code{ProjectFolder}. If left empty,
rcrunch will look in \code{envOrOption('crunch.default.project')} and error if nothing
is found.}
}
\value{
list suitable for JSONing and POSTing to create a dataset
}
\description{
Wrap variable metadata inside a dataset entity
}
\keyword{internal}
