% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllGenerics.R, R/geo.R
\docType{class}
\name{CrunchGeography-class}
\alias{CrunchGeography-class}
\alias{CrunchGeography}
\alias{Geodata-class}
\alias{Geodata}
\alias{geo}
\alias{geo<-}
\alias{geo,CrunchVariable-method}
\alias{geo<-,CrunchVariable,CrunchGeography-method}
\alias{geo<-,CrunchVariable,NULL-method}
\alias{availableGeodata}
\title{Geography properties for crunch variables}
\usage{
CrunchGeography(..., data = NULL)

geo(x)

geo(x) <- value

\S4method{geo}{CrunchVariable}(x)

\S4method{geo}{CrunchVariable,CrunchGeography}(x) <- value

\S4method{geo}{CrunchVariable,`NULL`}(x) <- value

availableGeodata(x = getAPIRoot())
}
\arguments{
\item{...}{for \code{CrunchGeography}, named arguments from which to construct a
\code{CrunchGeography}: \code{geodatum}, \code{feature_key}, and \code{match_field}}

\item{data}{for \code{CrunchGeography}, list of named arguments from which to construct a
\code{CrunchGeography}: \code{geodatum}, \code{feature_key}, and \code{match_field}}

\item{x}{a crunch variable}

\item{value}{value of the geography property to set}
}
\value{
geographic information of class \code{CrunchGeography} (\code{NULL} if there is none)
}
\description{
Crunch stores geographic data as variable metadata. There are a number of
functions that help access and change this metadata.
}
\details{
\code{geo} retrieves the geographic information associate with a variable.
If there is geographic information it returns an object of class
\code{CrunchGeography} otherwise it returns \code{NULL}.

\code{CrunchGeography} objects store geography metadata from a variable. There are three slots:
\itemize{
\item \code{geodatum} an object of class CrunchGeodata which stores references
to the Crunch-hosted (geo|topo)json to use
\item \code{feature_key} a character string representing the feature inside of the
(geo|topo)json which is used to match \code{match_field} (e.g. properties.name)
\item \code{match_field} a character string representing the variable metadata information which is used
to match \code{feature_key} to (e.g. name)
}
}
\examples{
\dontrun{
geo(ds$location)

geo(ds$location)$feature_key <- "properties.name"
geo(ds$location)$match_field <- "name"
}
}
