setMethod("folderExtraction", "ProjectFolder", function(x, tuple) {
    ## "tuple" is a list of length 1, name is URL, contents is the actual tuple
    url <- names(tuple)
    tuple <- tuple[[1]]
    if (tuple$type == "project") {
        return(ProjectFolder(crGET(url)))
    } else {
        return(loadDatasetFromURL(url))
    }
})

setMethod("personalFolder", "ProjectFolder", function (x) {
    # TODO: implement the real personal project. This is legacy behavior
    datasets()
})

#' @rdname teams
#' @export
setMethod("members", "ProjectFolder", function(x) {
    MemberCatalog(crGET(shojiURL(x, "catalogs", "members")))
})

#' @rdname teams
#' @export
setMethod("members<-", c("ProjectFolder", "MemberCatalog"), function(x, value) {
    ## TODO: something
    ## For now, assume action already done in other methods, like NULL
    ## assignment above.
    return(x)
})

#' @rdname teams
#' @export
setMethod("members<-", c("ProjectFolder", "character"), function(x, value) {
    value <- setdiff(value, emails(members(x)))
    if (length(value)) {
        payload <- sapply(value, emptyObject, simplify = FALSE)
        crPATCH(self(members(x)), body = toJSON(payload))
    }
    return(x)
})

#' @rdname catalog-extract
#' @export
setMethod(
    "[[<-", c("ProjectFolder", "character", "missing", "list"),
    function(x, i, j, value) {
        # This is for backwards compatibility with the old project API
        if (i %in% names(x)) {
            ## TODO: update team attributes
            halt("Cannot (yet) modify project attributes")
        } else {
            ## Creating a new project
            proj <- do.call(
                newProject,
                modifyList(value, list(name = i, catalog = x))
            )
            return(refresh(x))
        }
    }
)

#' @rdname catalog-extract
#' @export
setMethod(
    "[[<-", c("ProjectFolder", "character", "missing", "ProjectFolder"),
    function(x, i, j, value) {
        # This is for backwards compatibility with the old project API

        ## Assumes that modifications have already been persisted
        ## by other operations on the team entity (like members<-)
        if (i %in% names(x) && identical(self(x[[i]]), self(value))) {
            # TODO: could patch up the tuple with the entity
            return(refresh(x))
        } else {
            halt("Not implemented")
        }
    }
)

setMethod("active", "ProjectFolder", function(x) {
    index(x) <- Filter(function(a) !isTRUE(a$archived), index(x))
    return(x)
})

setMethod("archived", "ProjectFolder", function(x) {
    index(x) <- Filter(function(a) isTRUE(a$archived), index(x))
    return(x)
})
