% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-transforms.R, R/transform.R
\docType{methods}
\name{showTransforms,CrunchCube-method}
\alias{showTransforms,CrunchCube-method}
\alias{showTransforms}
\alias{showTransforms,CategoricalVariable-method}
\title{Show transformations on a Crunch object}
\usage{
\S4method{showTransforms}{CrunchCube}(x)

\S4method{showTransforms}{CategoricalVariable}(x)
}
\arguments{
\item{x}{a Categorical variable or CrunchCube}
}
\value{
summary of the variable, or the full CrunchCube with transforms applied
}
\description{
\code{showTransforms([variable])} shows a summary of a categorical variable that
has transforms with the transforms calculated and applied. This is useful to
see what kind transforms exist before including the variable in a CrunchCube.
}
\details{
\code{showTransforms([CrunchCube])} shows the CrunchCube with all transforms
calculated and applied. This is the default display method for cubes, so
should not be frequently needed.

In both cases, an array is returned that includes the values of both the
underlying data (either category counts or CrunchCube cell values) as well as
the transformations applied.
}
\examples{
\dontrun{
showTransforms(ds$variable)
}
}
