% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multitest_helpers.R
\name{print.multitest_evaluation.summary}
\alias{print.multitest_evaluation.summary}
\title{Print a multitest_evaluation.summary object}
\usage{
\method{print}{multitest_evaluation.summary}(x, digits = max(3,
  getOption("digits") - 4), ...)
}
\arguments{
\item{x}{Object to print}

\item{digits}{Numeric. Number of digits to print. Defaults to \code{max(3, getOption("digits")-4)}}

\item{...}{Further arguments to \code{print.multitest_evaluation.summary}}
}
\description{
Print a multitest_evaluation.summary object
}
\examples{
\dontrun{
library(crtests)
library(randomForest)
library(rpart)
library(caret)
library(stringr)

# A classification multitest. The result is an object of class multitest_evaluation
multitest_evaluation <- multitest(data = iris,
                                  dependent = "Species",
                                  problem = "classification",
                                  method = "randomForest",
                                  name = "An example classification multitest",
                                  iterations = 10,
                                  cross_validation = TRUE,
                                  preserve_distribution = TRUE
)
print(summary(multitest_evaluation))

}
}

