% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_list}
\alias{body_add_list}
\alias{body_add_list_item}
\title{Add a list to an \code{officer} document}
\usage{
body_add_list(doc, value, ordered = FALSE, style = NULL, ...)

body_add_list_item(doc, value, ordered = FALSE, style = NULL, ...)
}
\arguments{
\item{doc}{a docx object}

\item{value}{a character (\code{body_add_list()}) or a string (\code{body_add_list_item})}

\item{ordered}{if TRUE, adds an ordered list, if FALSE, adds a bullet list}

\item{style}{specify the style manually, overriding \code{ordered}. A better way is to set options \code{crosstable_style_list_ordered} and \code{crosstable_style_list_unordered} globally.}

\item{...}{passed on to \code{\link[officer:body_add_par]{officer::body_add_par()}}}
}
\value{
The docx object \code{doc}
}
\description{
Add a list to an \code{officer} document
}
\details{
Ordered lists and bullet lists are not supported by the default officer template (see \href{#262}{https://github.com/davidgohel/officer/issues/262}). You have to manually set custom styles matching those list in a custom Word template file. Then, you can use either the \code{style} argument or crosstable options. See examples for more details.
}
\examples{
\dontrun{
#For this example to work, `my_template.docx` should include styles named
#`ordered_list` and `unordered_list`

library(officer)
library(crosstable)
options(crosstable_style_list_ordered="ordered_list")
options(crosstable_style_list_unordered="unordered_list")

read_docx("my_template.docx") \%>\%
 body_add_list(c("Numbered item 1", "Numbered item 2"), ordered = TRUE) \%>\%
 body_add_list_item("Numbered item 3", ordered = TRUE) \%>\%
 body_add_list(c("Bullet item 1", "Bullet item 2"), ordered = FALSE) \%>\%
 body_add_list_item("Bullet item 3", ordered = FALSE) \%>\%
 write_and_open()
}
}
\author{
Dan Chaltiel
}
