% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatplot.crossnma.R
\name{heatplot.crossnma}
\alias{heatplot.crossnma}
\alias{heatplot}
\title{Heat Plot}
\usage{
\method{heatplot}{crossnma}(
  x,
  median = TRUE,
  exp = TRUE,
  order = NULL,
  low.colour = "red",
  mid.colour = "white",
  high.colour = "springgreen4",
  cov1.value = NULL,
  cov2.value = NULL,
  cov3.value = NULL,
  size = 6,
  size.trt = 20,
  size.axis = 12,
  digits = 2,
  ...
)

heatplot(x, ...)
}
\arguments{
\item{x}{An object created with \code{\link{crossnma}}.}

\item{median}{A logical indicating whether to use the median
(default) or mean to measure relative treatment effects.}

\item{exp}{If TRUE (default), odds ratios are displayed. If FALSE,
log odds ratios will be presented.}

\item{order}{A vector of treatment names (character) representing
the order in which to display these treatments.}

\item{low.colour}{A string indicating the colour of low relative
treatment effects for the heat plot (e.g odds ratio of ~0.5)}

\item{mid.colour}{A string indicating the colour of null relative
treatment effects for the heat plot (e.g odds ratio of ~1.0).}

\item{high.colour}{A string indicating the colour of high relative
treatment effects for the heat plot (e.g odds ratio of ~2.0).}

\item{cov1.value}{The participant covariate value of \code{cov1}
for which to report the results. Must be specified for network
meta-regression and when individual participant dataset is used
in the analysis. For dichotomous covariates, a character of the
level (used in the data) should be indicated.}

\item{cov2.value}{The participant covariate value of \code{cov2}
for which to report the results. Must be specified for network
meta-regression and when individual participant dataset is used
in the analysis. For dichotomous covariates, a character of the
level (used in the data) should be indicated.}

\item{cov3.value}{The participant covariate value of \code{cov3}
for which to report the results. Must be specified for network
meta-regression and when individual participant dataset is used
in the analysis. For dichotomous covariates, a character of the
level (used in the data) should be indicated.}

\item{size}{The size of cell entries with the relative treatment
effect and 95\% credible intervals.}

\item{size.trt}{The size of treatment names placed on the top and
left of the plot.}

\item{size.axis}{The size of labels on the top and left of the plot}

\item{digits}{The number of digits to be used when displaying the
results.}

\item{\dots}{Additional arguments (ignored at the moment).}
}
\value{
League heat plot, where a color scale is used to represent the
relative treatment effects.
}
\description{
Produces a heat plot that contain point estimates of relative
effects for all possible pairs of treatments along with 95\%
credible intervals obtained with the quantile method.
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
head(stddata) # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
# (suppress warning 'Adaptation incomplete' due to n.adapt = 20)
fit <-
  suppressWarnings(crossnma(mod, n.adapt = 20,
    n.iter = 50, thin = 1, n.chains = 3))

# Create a heat plot
heatplot(fit)

}
\seealso{
\code{\link{crossnma}}
}
\author{
Tasnim Hamza \email{tasnim.hamza@ispm.unibe.ch}
}
