% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle-crop.R
\name{circle_crop}
\alias{circle_crop}
\title{Circle crop}
\usage{
circle_crop(images, to = NULL)
}
\arguments{
\item{images}{Vector of image paths, either local or urls. If urls the images
will be downloaded first.}

\item{to}{Path to new location}
}
\value{
Path to cropped images
}
\description{
Reads in an image and circle crops it with a transparent
background. If a new path is given it will save the cropped images to
the new location. If no path is given it will save to a temporary location
which will be cleared when the session is closed
}
\examples{
library(magick)

img_paths <- c(
  "https://openpsychometrics.org/tests/characters/test-resources/pics/BB/1.jpg",
  "https://openpsychometrics.org/tests/characters/test-resources/pics/BB/3.jpg",
  "https://openpsychometrics.org/tests/characters/test-resources/pics/BB/9.jpg",
  "https://openpsychometrics.org/tests/characters/test-resources/pics/BB/8.jpg")

 img_paths_cropped <- circle_crop(img_paths)

 imgs <- image_read(img_paths_cropped)
 image_montage(imgs)
}
