% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{predict.crf}
\alias{predict.crf}
\title{Predict the label sequence based on the Conditional Random Field}
\usage{
\method{predict}{crf}(
  object,
  newdata,
  group,
  type = c("marginal", "sequence"),
  trace = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class crf as returned by \code{\link{crf}}}

\item{newdata}{a character matrix of data containing attributes about the label sequence \code{y} or an object which can be coerced to a character matrix. 
This data should be provided in the same format as was used for training the model}

\item{group}{an integer or character vector of the same length as nrow \code{newdata} indicating the group the sequence \code{y} belongs to (e.g. a document or sentence identifier)}

\item{type}{either 'marginal' or 'sequence' to get predictions at the level of \code{newdata} or a the level of the sequence \code{group}. Defaults to \code{'marginal'}}

\item{trace}{a logical indicating to show the trace of the labelling output. Defaults to \code{FALSE}.}

\item{...}{not used}
}
\value{
If \code{type} is 'marginal': a data.frame with columns label and marginal containing the viterbi decoded predicted label and marginal probability. \cr
If \code{type} is 'sequence': a data.frame with columns group and probability containing for each sequence group the probability of the sequence.
}
\description{
Predict the label sequence based on the Conditional Random Field
}
\examples{
\donttest{
\dontshow{if(require(udpipe))\{}
library(udpipe)
data(airbnb_chunks, package = "crfsuite")
udmodel <- udpipe_download_model("dutch-lassysmall")
udmodel <- udpipe_load_model(udmodel$file_model)
airbnb_tokens <- unique(airbnb_chunks[, c("doc_id", "text")])
airbnb_tokens <- udpipe_annotate(udmodel, 
                                 x = airbnb_tokens$text, 
                                 doc_id = airbnb_tokens$doc_id)
airbnb_tokens <- as.data.frame(airbnb_tokens)
x <- merge(airbnb_chunks, airbnb_tokens)
x <- crf_cbind_attributes(x, terms = c("upos", "lemma"), by = "doc_id")
model <- crf(y = x$chunk_entity, 
             x = x[, grep("upos|lemma", colnames(x))], 
             group = x$doc_id, 
             method = "lbfgs", options = list(max_iterations = 5)) 
scores <- predict(model, 
                  newdata = x[, grep("upos|lemma", colnames(x))], 
                  group = x$doc_id, type = "marginal")
head(scores)
scores <- predict(model, 
                  newdata = x[, grep("upos|lemma", colnames(x))], 
                  group = x$doc_id, type = "sequence")
head(scores)


## cleanup for CRAN
file.remove(model$file_model)
file.remove("modeldetails.txt")
file.remove(udmodel$file)
\dontshow{\} # End of main if statement running only if the required packages are installed}
}
}
\seealso{
\code{\link{crf}}
}
