% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\docType{data}
\name{crf_caretmethod}
\alias{crf_caretmethod}
\title{Functionality allowing to tune a crfsuite model using caret}
\format{
see details
}
\usage{
crf_caretmethod
}
\description{
The object \code{crf_caretmethod} contains functionality to tune a crf model using caret.
Each list elment of \code{crf_caretmethod} is a list of functions 
which can be passed on to the \code{method} argument of \code{caret::train} to tune the hyperparameters of the crfsuite model.
}
\details{
If you want to tune the hyperparameters of a crfsuite model 
(see \code{\link{crf_options}} and the \code{options} argument of \code{\link{crf}}), you can use the \code{caret} package. \cr
In order to facilitate this tuning, an object called \code{crf_caretmethod} has been made available. 
The object \code{crf_caretmethod} is a list with 6 elements, where each of these 6 elements can be used in 
tuning the CRF hyperparemeters by passing it on to the \code{method} argument of the \code{train} function of the \code{caret} package.\cr
The list has elements 'default', 'lbfgs', 'l2sgd', 'averaged_perceptron', 'passive_aggressive' and 'arow'.
Each list element corresponds to arguments that you need to tune for each \code{method} as used in \code{\link{crf}}. \cr
For \code{crf_caretmethod}
\enumerate{
\item lbfgs: Tuning across all hyperparameters for method lbfgs: L-BFGS with L1/L2 regularization
\item l2sgd: Tuning across all hyperparameters for method l2sgd: SGD with L2-regularization
\item averaged_perceptron: Tuning across all hyperparameters for method averaged-perceptron: Averaged Perceptron
\item passive_aggressive: Tuning across all hyperparameters for method passive-aggressive: Passive Aggressive
\item arow: Tuning across all hyperparameters for method arow: Adaptive Regularization of Weights (AROW)
\item default: Tune over the hyperparameters feature.minfreq, feature.possible_states, feature.possible_transitions, max_iterations. While tuning these, it uses the default hyperparameters for each method. This tuning allows you to compare the 5 methods.
}
For details on the hyperparameter definitions: see \code{\link{crf_options}}
}
\keyword{datasets}
