% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{airbnb_chunks}
\alias{airbnb_chunks}
\title{Dutch reviews of AirBnB customers on Brussels address locations manually tagged with entities}
\description{
The \code{\link{airbnb}} dataset was manually annotated with the shiny app inside this R package.
The annotation shows chunks of data which have been flagged with the following categories: PERSON, LOCATION, DISTANCE.
The dataset is an object of class \code{chunkrange} and of type data.frame which contains the following fields:
\itemize{
 \item{doc_id: }{a unique identifier of the review, which is also available in \code{\link{airbnb}}}
 \item{listing_id: }{the airbnb address identifier}
 \item{text: }{text with the feedback of a customer on his visit in the AirBnB appartment}
 \item{chunk_id: }{a chunk identifier}
 \item{chunk_entity: }{a chunk entity label}
 \item{chunk: }{the text of the chunk which is a substring of \code{text}}
 \item{start: }{the starting position in \code{text} where the \code{chunk} is found}
 \item{end: }{the end position in \code{text} where the \code{chunk} is found}
}
}
\examples{
data(airbnb_chunks)
str(airbnb_chunks)
head(airbnb_chunks)
}
\seealso{
\code{\link{airbnb_chunks}}
}
