% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_pbs.R
\name{crew_controller_pbs}
\alias{crew_controller_pbs}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Create a controller with a
PBS/TORQUE launcher.}
\usage{
crew_controller_pbs(
  name = NULL,
  workers = 1L,
  host = NULL,
  port = NULL,
  tls = crew::crew_tls(mode = "automatic"),
  tls_enable = NULL,
  tls_config = NULL,
  serialization = NULL,
  seconds_interval = 0.25,
  seconds_timeout = 60,
  seconds_launch = 86400,
  seconds_idle = 300,
  seconds_wall = Inf,
  seconds_exit = NULL,
  retry_tasks = NULL,
  tasks_max = Inf,
  tasks_timers = 0L,
  reset_globals = TRUE,
  reset_packages = FALSE,
  reset_options = FALSE,
  garbage_collection = FALSE,
  crashes_error = NULL,
  r_arguments = c("--no-save", "--no-restore"),
  crashes_max = 5L,
  backup = NULL,
  options_metrics = crew::crew_options_metrics(),
  options_cluster = crew.cluster::crew_options_pbs(),
  verbose = NULL,
  command_submit = NULL,
  command_terminate = NULL,
  command_delete = NULL,
  script_directory = NULL,
  script_lines = NULL,
  pbs_cwd = NULL,
  pbs_log_output = NULL,
  pbs_log_error = NULL,
  pbs_log_join = NULL,
  pbs_memory_gigabytes_required = NULL,
  pbs_cores = NULL,
  pbs_walltime_hours = NULL
)
}
\arguments{
\item{name}{Character string, name of the launcher. If the name is
\code{NULL}, then a name is automatically generated when the launcher starts.}

\item{workers}{Maximum number of workers to run concurrently
when auto-scaling, excluding task retries and manual calls to \code{launch()}.
Special workers allocated for task retries
do not count towards this limit, so the number of workers running at a
given time may exceed this maximum.
A smaller number of workers may run if the number of executing tasks
is smaller than the supplied value of the \code{workers} argument.}

\item{host}{IP address of the \code{mirai} client to send and receive tasks.
If \code{NULL}, the host defaults to the local IP address.}

\item{port}{TCP port to listen for the workers. If \code{NULL},
then an available ephemeral port is automatically chosen.
Controllers running simultaneously on the same computer
(as in a controller group) must not share the same TCP port.}

\item{tls}{A TLS configuration object from \code{\link[crew:crew_tls]{crew_tls()}}.}

\item{tls_enable}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{tls_config}{Deprecated on 2023-09-15 in version 0.4.1.
Use argument \code{tls} instead.}

\item{serialization}{Either \code{NULL} (default) or an object produced by
\code{\link[mirai:serial_config]{mirai::serial_config()}} to control the serialization
of data sent to workers. This can help with either more efficient
data transfers or to preserve attributes of otherwise
non-exportable objects (such as \code{torch} tensors or \code{arrow} tables).
See \code{?mirai::serial_config} for details.}

\item{seconds_interval}{Number of seconds between
polling intervals waiting for certain internal
synchronous operations to complete. In certain cases, exponential
backoff is used with this argument passed to \code{seconds_max}
in a \code{\link[crew:crew_throttle]{crew_throttle()}} object.}

\item{seconds_timeout}{Number of seconds until timing
out while waiting for certain synchronous operations to complete,
such as checking \code{mirai::status()}.}

\item{seconds_launch}{Seconds of startup time to allow.
A worker is unconditionally assumed to be alive
from the moment of its launch until \code{seconds_launch} seconds later.
After \code{seconds_launch} seconds, the worker is only
considered alive if it is actively connected to its assign websocket.}

\item{seconds_idle}{Maximum number of seconds that a worker can idle
since the completion of the last task. If exceeded, the worker exits.
But the timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{idletime} argument of \code{mirai::daemon()}. \code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, so please allow enough idle
time for a new worker to be delegated a new task.}

\item{seconds_wall}{Soft wall time in seconds.
The timer does not launch until \code{tasks_timers} tasks
have completed.
See the \code{walltime} argument of \code{mirai::daemon()}.}

\item{seconds_exit}{Deprecated on 2023-09-21 in version 0.1.2.9000.
No longer necessary.}

\item{retry_tasks}{Deprecated on 2025-01-13 (\code{crew} version 0.10.2.9002).}

\item{tasks_max}{Maximum number of tasks that a worker will do before
exiting. See the \code{maxtasks} argument of \code{mirai::daemon()}.
\code{crew} does not
excel with perfectly transient workers because it does not micromanage
the assignment of tasks to workers, it is recommended to set
\code{tasks_max} to a value greater than 1.}

\item{tasks_timers}{Number of tasks to do before activating
the timers for \code{seconds_idle} and \code{seconds_wall}.
See the \code{timerstart} argument of \code{mirai::daemon()}.}

\item{reset_globals}{\code{TRUE} to reset global environment
variables between tasks, \code{FALSE} to leave them alone.}

\item{reset_packages}{\code{TRUE} to unload any packages loaded during
a task (runs between each task), \code{FALSE} to leave packages alone.}

\item{reset_options}{\code{TRUE} to reset global options to their original
state between each task, \code{FALSE} otherwise. It is recommended to
only set \code{reset_options = TRUE} if \code{reset_packages} is also \code{TRUE}
because packages sometimes rely on options they set at loading time.}

\item{garbage_collection}{\code{TRUE} to run garbage collection between
tasks, \code{FALSE} to skip.}

\item{crashes_error}{Deprecated on 2025-01-13 (\code{crew} version 0.10.2.9002).}

\item{r_arguments}{Optional character vector of command line arguments
to pass to \code{Rscript} (non-Windows) or \code{Rscript.exe} (Windows)
when starting a worker. Example:
\code{r_arguments = c("--vanilla", "--max-connections=32")}.}

\item{crashes_max}{In rare cases, a worker may exit unexpectedly
before it completes its current task. If this happens, \code{pop()}
returns a status of \code{"crash"} instead of \code{"error"} for the task.
The controller does not automatically retry the task, but
you can retry it manually by calling \code{push()} again and using the same
task name as before. (However, \code{targets} pipelines running \code{crew}
do automatically retry tasks whose workers crashed.)

\code{crashes_max} is a non-negative integer, and it sets the maximum number of
allowable consecutive crashes for a given task.
If a task's worker crashes more than \code{crashes_max} times in a row,
then \code{pop()} throws an error when it tries to return the results
of the task.}

\item{backup}{An optional \code{crew} controller object, or \code{NULL} to omit.
If supplied, the \code{backup} controller runs any pushed tasks that have
already reached \code{crashes_max} consecutive crashes.
Using \code{backup}, you can create
a chain of controllers with different levels of resources
(such as worker memory and CPUs) so that a task that fails on
one controller can retry using incrementally more powerful workers.
All controllers in a backup chain should be part of the same
controller group (see \code{\link[crew:crew_controller_group]{crew_controller_group()}}) so you can call the
group-level \code{pop()} and \code{collect()} methods to make sure you get results
regardless of which controller actually ended up running the task.

Limitations of \code{backup}:
* \code{crashes_max} needs to be positive in order for \code{backup} to be used.
Otherwise, every task would always skip the current controller and
go to \code{backup}.
* \code{backup} cannot be a controller group. It must be an ordinary
controller.}

\item{options_metrics}{Either \code{NULL} to opt out of resource metric logging
for workers, or an object from \code{\link[crew:crew_options_metrics]{crew_options_metrics()}} to enable
and configure resource metric logging for workers.
For resource logging to run,
the \code{autometric} R package version 0.1.0 or higher
must be installed.}

\item{options_cluster}{An options list from
\code{\link[=crew_options_pbs]{crew_options_pbs()}} with cluster-specific configuration options.}

\item{verbose}{Deprecated. Use \code{options_cluster} instead.}

\item{command_submit}{Deprecated. Use \code{options_cluster} instead.}

\item{command_terminate}{Deprecated. Use \code{options_cluster} instead.}

\item{command_delete}{Deprecated on 2024-01-08 (version 0.1.4.9001).
Use \code{command_terminate} instead.}

\item{script_directory}{Deprecated. Use \code{options_cluster} instead.}

\item{script_lines}{Deprecated. Use \code{options_cluster} instead.}

\item{pbs_cwd}{Deprecated. Use \code{options_cluster} instead.}

\item{pbs_log_output}{Deprecated. Use \code{options_cluster} instead.}

\item{pbs_log_error}{Deprecated. Use \code{options_cluster} instead.}

\item{pbs_log_join}{Deprecated. Use \code{options_cluster} instead.}

\item{pbs_memory_gigabytes_required}{Deprecated.
Use \code{options_cluster} instead.}

\item{pbs_cores}{Deprecated. Use \code{options_cluster} instead.}

\item{pbs_walltime_hours}{Deprecated. Use \code{options_cluster} instead.}
}
\description{
Create an \code{R6} object to submit tasks and
launch workers on a PBS or TORQUE cluster.
}
\section{Attribution}{

The template files at
\url{https://github.com/mschubert/clustermq/tree/master/inst}
informed the development of the \code{crew} launcher plugins in
\code{crew.cluster}, and we would like to thank
Michael Schubert for developing \code{clustermq} and releasing it under
the permissive Apache License 2.0.
See the \code{NOTICE} and \code{README.md} files in the \code{crew.cluster}
source code for additional attribution.
}

\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
controller <- crew_controller_pbs()
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()$result
controller$terminate()
}
}
\seealso{
Other pbs: 
\code{\link{crew_class_launcher_pbs}},
\code{\link{crew_launcher_pbs}()},
\code{\link{crew_options_pbs}()}
}
\concept{pbs}
