% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_options_slurm.R
\name{crew_options_slurm}
\alias{crew_options_slurm}
\title{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} SLURM options.}
\usage{
crew_options_slurm(
  verbose = FALSE,
  command_submit = as.character(Sys.which("sbatch")),
  command_terminate = as.character(Sys.which("scancel")),
  script_directory = tempdir(),
  script_lines = character(0L),
  log_output = "/dev/null",
  log_error = "/dev/null",
  memory_gigabytes_required = NULL,
  memory_gigabytes_per_cpu = NULL,
  cpus_per_task = NULL,
  time_minutes = NULL,
  partition = NULL
)
}
\arguments{
\item{verbose}{Logical, whether to see console output and error messages
when submitting worker.}

\item{command_submit}{Character of length 1,
file path to the executable to submit a worker job.}

\item{command_terminate}{Character of length 1,
file path to the executable to terminate a worker job.
Set to \code{""} to skip manually terminating the worker.
Unless there is an issue with the platform,
the job should still exit thanks to the NNG-powered network programming
capabilities of \code{mirai}. Still, if you set \code{command_terminate = ""},
you are assuming extra responsibility for manually monitoring
your jobs on the cluster and manually terminating jobs as appropriate.}

\item{script_directory}{Character of length 1, directory path to the
job scripts. Just before each job submission, a job script
is created in this folder. Script base names are unique to each
launcher and worker, and the launcher deletes the script when the
worker is manually terminated. \code{tempdir()} is the default, but it
might not work for some systems.
\code{tools::R_user_dir("crew.cluster", which = "cache")}
is another reasonable choice.}

\item{script_lines}{Optional character vector of additional lines to be
added to the job script just after the more common flags.
An example would be \code{script_lines = "module load R"} if your cluster
supports R through an environment module.}

\item{log_output}{Character of length 1, file pattern to control
the locations of the SLURM worker log files. By default, both standard
output and standard error go to the same file.
\code{log_output = "crew_log_\%A.txt"} translates to a line of
\verb{#SBATCH --output=crew_log_\%A.txt} in the SLURM job script,
where \verb{\%A} is replaced by the job ID of the worker.
The default is \verb{/dev/null} to omit these logs.
Set \code{log_output = NULL} to omit this line from the job script.}

\item{log_error}{Character of length 1, file pattern for standard
error. \code{log_error = "crew_log_\%A.txt"} translates to a line of
\verb{#SBATCH --error=crew_log_\%A.txt} in the SLURM job script,
where \verb{\%A} is replaced by the job ID of the worker.
The default is \verb{/dev/null} to omit these logs.
Set \code{log_error = NULL} to omit this line from the job script.}

\item{memory_gigabytes_required}{Positive numeric vector,
usually with a single element.
Supply a vector to make \code{memory_gigabytes_required} a retryable option
(see the "Retryable options" section for details).

Each element is of \code{memory_gigabytes_required}
the total number of gigabytes of memory required per node.
\code{memory_gigabytes_required = 2.40123}
translates to a line of \verb{#SBATCH --mem=2041M}
in the SLURM job script.
\code{memory_gigabytes_required = NULL} omits this line.}

\item{memory_gigabytes_per_cpu}{Positive numeric vector,
usually with a single element.
Supply a vector to make \code{memory_gigabytes_per_cpu} a retryable option
(see the "Retryable options" section for details).

\code{memory_gigabytes_per_cpu} is the gigabytes of
memory required per CPU.
\code{memory_gigabytes_per_cpu = 2.40123}
translates to a line of \verb{#SBATCH --mem-per-cpu=2041M}
in the SLURM job script.
\code{memory_gigabytes_per_cpu = NULL} omits this line.}

\item{cpus_per_task}{Optional positive integer vector,
usually with a single element.
Supply a vector to make \code{cpus_per_task} a retryable option
(see the "Retryable options" section for details).

\code{cpus_per_task} is the number of CPUs for the worker.
\code{cpus_per_task = 4} translates
to a line of \verb{#SBATCH --cpus-per-task=4} in the SLURM job script.
\code{cpus_per_task = NULL} omits this line.}

\item{time_minutes}{Numeric of length 1, usually with a single element.
Supply a vector to make \code{time_minutes} a retryable option
(see the "Retryable options" section for details).

\code{time_minutes} is the number of minutes to
designate as the wall time of \code{crew} each worker instance on the
SLURM cluster. \code{time_minutes = 60} translates to a line of
\verb{#SBATCH --time=60} in the SLURM job script. \code{time_minutes = NULL}
omits this line.}

\item{partition}{Character of vector, usually with a single element.
Supply a vector to make \code{partition} a retryable option
(see the "Retryable options" section for details).

\code{partition} is the name of the SLURM partition to
create workers on. \code{partition = "partition1,partition2"}
translates to a line of \verb{#SBATCH --partition=partition1,partition2}
in the SLURM job script. \code{partition = NULL}
omits this line.}
}
\value{
A classed list of options.
}
\description{
Set options for SLURM job management.
}
\section{Retryable options}{

Arguments \code{memory_gigabytes_required}, \code{memory_gigabytes_per_cpu},
\code{cpus_per_task}, \code{time_minutes}, and \code{partition} are retryable options.
Each of these arguments be a vector where each successive element is
used during a retry if the worker previously exited without
completing all its assigned tasks.
The last element of the vector is used if there are more retries than
the length of the vector.
Control the number of allowable retries with \code{crashes_error}
argument of the controller.
}

\section{Attribution}{

The template files at
\url{https://github.com/mschubert/clustermq/tree/master/inst}
informed the development of the \code{crew} launcher plugins in
\code{crew.cluster}, and we would like to thank
Michael Schubert for developing \code{clustermq} and releasing it under
the permissive Apache License 2.0.
See the \code{NOTICE} and \code{README.md} files in the \code{crew.cluster}
source code for additional attribution.
}

\examples{
  crew_options_slurm()
}
\seealso{
Other slurm: 
\code{\link{crew_class_launcher_slurm}},
\code{\link{crew_class_monitor_slurm}},
\code{\link{crew_controller_slurm}()},
\code{\link{crew_launcher_slurm}()},
\code{\link{crew_monitor_slurm}()}
}
\concept{slurm}
