% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_aws_batch_monitor.R
\name{crew_class_aws_batch_monitor}
\alias{crew_class_aws_batch_monitor}
\title{AWS Batch monitor class}
\description{
AWS Batch job definition \code{R6} class
}
\details{
See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}
\seealso{
Other monitor: 
\code{\link{crew_aws_batch_monitor}()}
}
\concept{monitor}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{job_queue}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{job_definition}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{log_group}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{config}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{credentials}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{endpoint}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{region}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_aws_batch_monitor-new}{\code{crew_class_aws_batch_monitor$new()}}
\item \href{#method-crew_class_aws_batch_monitor-validate}{\code{crew_class_aws_batch_monitor$validate()}}
\item \href{#method-crew_class_aws_batch_monitor-register}{\code{crew_class_aws_batch_monitor$register()}}
\item \href{#method-crew_class_aws_batch_monitor-deregister}{\code{crew_class_aws_batch_monitor$deregister()}}
\item \href{#method-crew_class_aws_batch_monitor-describe}{\code{crew_class_aws_batch_monitor$describe()}}
\item \href{#method-crew_class_aws_batch_monitor-submit}{\code{crew_class_aws_batch_monitor$submit()}}
\item \href{#method-crew_class_aws_batch_monitor-terminate}{\code{crew_class_aws_batch_monitor$terminate()}}
\item \href{#method-crew_class_aws_batch_monitor-status}{\code{crew_class_aws_batch_monitor$status()}}
\item \href{#method-crew_class_aws_batch_monitor-log}{\code{crew_class_aws_batch_monitor$log()}}
\item \href{#method-crew_class_aws_batch_monitor-jobs}{\code{crew_class_aws_batch_monitor$jobs()}}
\item \href{#method-crew_class_aws_batch_monitor-active}{\code{crew_class_aws_batch_monitor$active()}}
\item \href{#method-crew_class_aws_batch_monitor-inactive}{\code{crew_class_aws_batch_monitor$inactive()}}
\item \href{#method-crew_class_aws_batch_monitor-submitted}{\code{crew_class_aws_batch_monitor$submitted()}}
\item \href{#method-crew_class_aws_batch_monitor-pending}{\code{crew_class_aws_batch_monitor$pending()}}
\item \href{#method-crew_class_aws_batch_monitor-runnable}{\code{crew_class_aws_batch_monitor$runnable()}}
\item \href{#method-crew_class_aws_batch_monitor-starting}{\code{crew_class_aws_batch_monitor$starting()}}
\item \href{#method-crew_class_aws_batch_monitor-running}{\code{crew_class_aws_batch_monitor$running()}}
\item \href{#method-crew_class_aws_batch_monitor-succeeded}{\code{crew_class_aws_batch_monitor$succeeded()}}
\item \href{#method-crew_class_aws_batch_monitor-failed}{\code{crew_class_aws_batch_monitor$failed()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-new}{}}}
\subsection{Method \code{new()}}{
AWS Batch job definition constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$new(
  job_queue = NULL,
  job_definition = NULL,
  log_group = NULL,
  config = NULL,
  credentials = NULL,
  endpoint = NULL,
  region = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_queue}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{job_definition}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{log_group}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{config}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{credentials}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{endpoint}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}

\item{\code{region}}{See \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
AWS Batch job definition object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Throws an error if a field is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-register"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-register}{}}}
\subsection{Method \code{register()}}{
Register a job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$register(
  image,
  platform_capabilities = "EC2",
  memory_units = "gigabytes",
  memory = NULL,
  cpus = NULL,
  gpus = NULL,
  seconds_timeout = NULL,
  scheduling_priority = NULL,
  tags = NULL,
  propagate_tags = NULL,
  parameters = NULL,
  job_role_arn = NULL,
  execution_role_arn = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{Character of length 1, Docker image used for each job.
You can supply a path to an image in Docker Hub or the full URI
of an image in an Amazon ECR repository.}

\item{\code{platform_capabilities}}{Optional character of length 1, either
\code{"EC2"} to run on EC2 or \code{"FARGATE"} to run on Fargate.}

\item{\code{memory_units}}{Character of length 1,
either \code{"gigabytes"} or \code{"mebibytes"} to set the units of the
\code{memory} argument. \code{"gigabytes"} is simpler for EC2 jobs, but
Fargate has strict requirements about specifying exact amounts of
mebibytes (MiB). for details, read
\url{https://docs.aws.amazon.com/cli/latest/reference/batch/register-job-definition.html} # nolint}

\item{\code{memory}}{Positive numeric of length 1, amount of memory to request
for each job.}

\item{\code{cpus}}{Positive numeric of length 1, number of virtual
CPUs to request for each job.}

\item{\code{gpus}}{Positive numeric of length 1, number of GPUs to
request for each job.}

\item{\code{seconds_timeout}}{Optional positive numeric of length 1,
number of seconds until a job times out.}

\item{\code{scheduling_priority}}{Optional nonnegative integer of length 1
between \code{0} and \code{9999}, priority of jobs. Jobs with higher-valued
priorities are scheduled first.
The priority only applies if the job queue has a fair share
policy. Set to \code{NULL} to omit.}

\item{\code{tags}}{Optional character vector of tags.}

\item{\code{propagate_tags}}{Optional logical of length 1, whether to propagate
tags from the job or definition to the ECS task.}

\item{\code{parameters}}{Optional character vector of key-value pairs
designating parameters for job submission.}

\item{\code{job_role_arn}}{Character of length 1,
Amazon resource name (ARN) of the job role.}

\item{\code{execution_role_arn}}{Character of length 1,
Amazon resource name (ARN) of the execution role.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{register()} method registers a simple
job definition using the job definition name and log group originally
supplied to \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
Job definitions created with \verb{$register()} are container-based
and use the AWS log driver.
For more complicated
kinds of jobs, we recommend skipping \code{register()}: first call
\url{https://www.paws-r-sdk.com/docs/batch_register_job_definition/}
to register the job definition, then supply the job definition
name to the \code{job_definition} argument of \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A one-row \code{tibble} with the job definition name, ARN, and
revision number of the registered job definition.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-deregister"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-deregister}{}}}
\subsection{Method \code{deregister()}}{
Attempt to deregister the job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$deregister()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Attempt to deregister the job definition whose name was
originally supplied to the \code{job_definition} argument of
\code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-describe"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-describe}{}}}
\subsection{Method \code{describe()}}{
Describe the current active revision of the job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$describe()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
If the job definition is not active or does not exist,
\code{describe()} returns \code{NULL}. Otherwise, it returns
a \code{tibble} with job definition information. Some fields
may be nested lists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-submit"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-submit}{}}}
\subsection{Method \code{submit()}}{
Submit a single AWS Batch job to the given job queue
under the given job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$submit(
  command = c("sleep", "300"),
  name = paste0("crew-aws-batch-job-", crew::crew_random_name()),
  memory_units = "gigabytes",
  memory = NULL,
  cpus = NULL,
  gpus = NULL,
  seconds_timeout = NULL,
  share_identifier = NULL,
  scheduling_priority_override = NULL,
  tags = NULL,
  propagate_tags = NULL,
  parameters = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Character vector with the command
to submit for the job. Usually a Linux shell command
with each term in its own character string.}

\item{\code{name}}{Character of length 1 with the job name.}

\item{\code{memory_units}}{Character of length 1,
either \code{"gigabytes"} or \code{"mebibytes"} to set the units of the
\code{memory} argument. \code{"gigabytes"} is simpler for EC2 jobs, but
Fargate has strict requirements about specifying exact amounts of
mebibytes (MiB). for details, read
\url{https://docs.aws.amazon.com/cli/latest/reference/batch/register-job-definition.html} # nolint}

\item{\code{memory}}{Positive numeric of length 1, amount of memory to request
for each job.}

\item{\code{cpus}}{Positive numeric of length 1, number of virtual
CPUs to request for each job.}

\item{\code{gpus}}{Positive numeric of length 1, number of GPUs to
request for each job.}

\item{\code{seconds_timeout}}{Optional positive numeric of length 1,
number of seconds until a job times out.}

\item{\code{share_identifier}}{Character of length 1 with the share
identifier of the job. Only applies if the job queue has a
scheduling policy. Read the official AWS Batch documentation
for details.}

\item{\code{scheduling_priority_override}}{Optional nonnegative integer
of length between \code{0} and \code{9999}, priority of the job.
This value overrides the priority in the job definition.
Jobs with higher-valued priorities are scheduled first.
The priority applies if the job queue has a fair share policy.
Set to \code{NULL} to omit.}

\item{\code{tags}}{Optional character vector of tags.}

\item{\code{propagate_tags}}{Optional logical of length 1, whether to propagate
tags from the job or definition to the ECS task.}

\item{\code{parameters}}{Optional character vector of key-value pairs
designating parameters for job submission.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method uses the job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
Any jobs submitted this way are different from the
\code{crew} workers that the \code{crew} controller starts automatically
using the AWS Batch launcher plugin.
You may use the \code{submit()} method in the monitor for different
purposes such as testing.
}

\subsection{Returns}{
A one-row \code{tibble} with the name, ID, and
Amazon resource name (ARN) of the job.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate an AWS Batch job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$terminate(
  id,
  reason = "terminated by crew.aws.batch monitor"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Character of length 1, ID of the AWS Batch job to terminate.}

\item{\code{reason}}{Character of length 1, natural language explaining
the reason the job was terminated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-status"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-status}{}}}
\subsection{Method \code{status()}}{
Get the status of a single job
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$status(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Character of length 1, job ID. This is different
from the user-supplied job name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A one-row \code{tibble} with information about the job.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-log"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-log}{}}}
\subsection{Method \code{log()}}{
Get the CloudWatch log of a job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$log(id, start_from_head = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Character of length 1, job ID. This is different
from the user-supplied job name.}

\item{\code{start_from_head}}{Logical of length 1, whether to print earlier
log events before later ones.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method assumes the job has log driver \code{"awslogs"}
(specifying AWS CloudWatch) and that the log group is the one
prespecified in the \code{log_group} argument of
\code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}. This method cannot use
other log drivers such as Splunk, and it will fail if the log
group is wrong or missing.
}

\subsection{Returns}{
A \code{tibble} with log information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-jobs"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-jobs}{}}}
\subsection{Method \code{jobs()}}{
List all the jobs in the given job queue
with the given job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$jobs(
  status = c("submitted", "pending", "runnable", "starting", "running", "succeeded",
    "failed")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{Character vector of job states. Results are limited
to these job states.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-active"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-active}{}}}
\subsection{Method \code{active()}}{
List active jobs: submitted, pending,
runnable, starting, or running (not succeeded or failed).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$active()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-inactive"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-inactive}{}}}
\subsection{Method \code{inactive()}}{
List inactive jobs: ones whose status
is succeeded or failed (not submitted, pending,
runnable, starting, or running).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$inactive()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-submitted"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-submitted}{}}}
\subsection{Method \code{submitted()}}{
List jobs whose status is \code{"submitted"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$submitted()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-pending"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-pending}{}}}
\subsection{Method \code{pending()}}{
List jobs whose status is \code{"pending"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$pending()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-runnable"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-runnable}{}}}
\subsection{Method \code{runnable()}}{
List jobs whose status is \code{"runnable"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$runnable()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-starting"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-starting}{}}}
\subsection{Method \code{starting()}}{
List jobs whose status is \code{"starting"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$starting()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-running"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-running}{}}}
\subsection{Method \code{running()}}{
List jobs whose status is \code{"running"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$running()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-succeeded"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-succeeded}{}}}
\subsection{Method \code{succeeded()}}{
List jobs whose status is \code{"succeeded"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$succeeded()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_aws_batch_monitor-failed"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_aws_batch_monitor-failed}{}}}
\subsection{Method \code{failed()}}{
List jobs whose status is \code{"failed"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_aws_batch_monitor$failed()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_aws_batch_monitor]{crew_aws_batch_monitor()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
}
