% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/includeTaxa.R
\name{includeTaxa}
\alias{includeTaxa}
\title{Includes the list of taxa into the reconstructions.}
\usage{
includeTaxa(x, taxa, climate)
}
\arguments{
\item{x}{A \code{\link{crestObj}} produced by one of the \code{\link{crest}},
\code{\link{crest.get_modern_data}}, \code{\link{crest.calibrate}},
\code{\link{crest.reconstruct}} or \code{\link{loo}} functions.}

\item{taxa}{A vector of taxa to include.}

\item{climate}{A vector of climate variables to link the taxa with.}
}
\value{
Return the updated \code{\link{crestObj}}.
}
\description{
Includes the list of taxa into the reconstructions.
}
\examples{
data(reconstr)
print(reconstr$inputs$selectedTaxa)
reconstr <- includeTaxa(reconstr, reconstr$inputs$taxa.name, 'bio12')
## All the taxa are not selected for 'bio12', except for 'Taxon7' for which
## data are unavailable.
print(reconstr$inputs$selectedTaxa)

}
