% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{get_psi_plots}
\alias{get_psi_plots}
\alias{psi_plot}
\title{Plot PSI(Population Stability Index)}
\usage{
get_psi_plots(
  dat_train,
  dat_test = NULL,
  x_list = NULL,
  ex_cols = NULL,
  breaks_list = NULL,
  occur_time = NULL,
  g = 10,
  plot_show = TRUE,
  save_data = FALSE,
  file_name = NULL,
  parallel = FALSE,
  g_width = 8,
  dir_path = tempdir()
)

psi_plot(
  dat_train,
  x,
  dat_test = NULL,
  occur_time = NULL,
  g_width = 8,
  breaks_list = NULL,
  breaks = NULL,
  g = 10,
  plot_show = TRUE,
  save_data = FALSE,
  dir_path = tempdir()
)
}
\arguments{
\item{dat_train}{A data.frame with independent variables.}

\item{dat_test}{A data.frame of test data. Default is NULL.}

\item{x_list}{Names of independent variables.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{occur_time}{The name of occur time.}

\item{g}{Number of initial breakpoints for equal frequency binning.}

\item{plot_show}{Logical, show model performance in current graphic device. Default is FALSE.}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE.}

\item{file_name}{The name for periodically saved data file. Default is NULL.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{g_width}{The width of graphs.}

\item{dir_path}{The path for periodically saved graphic files.}

\item{x}{The name of an independent variable.}

\item{breaks}{Splitting points for a continues variable.}
}
\description{
You can use the \code{psi_plot} to plot PSI of your data.
\code{get_psi_plots} can loop through plots for all specified independent variables.
}
\examples{
train_test <- train_test_split(UCICreditCard[1:1000,], split_type = "Random",
 prop = 0.8, save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
get_psi_plots(dat_train[, c(8, 9)], dat_test = dat_test[, c(8, 9)])
}
