% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{cor_plot}
\alias{cor_plot}
\title{Correlation Plot}
\usage{
cor_plot(
  dat,
  dir_path = tempdir(),
  x_list = NULL,
  gtitle = NULL,
  save_data = FALSE,
  plot_show = FALSE
)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{dir_path}{The path for periodically saved graphic files. Default is "./model/LR"}

\item{x_list}{Names of independent variables.}

\item{gtitle}{The title of the graph & The name for periodically saved graphic file. Default is "_correlation_of_variables".}

\item{save_data}{Logical, save results in locally specified folder. Default is TRUE}

\item{plot_show}{Logical, show graph in current graphic device.}
}
\description{
\code{cor_plot} is for ploting correlation matrix
}
\examples{
train_test <- train_test_split(UCICreditCard,
split_type = "Random", prop = 0.8,save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
cor_plot(dat_train[,8:12],plot_show = TRUE)
}
