% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimmed_quantile.R
\name{trimmed_quantile}
\alias{trimmed_quantile}
\title{Trimmed Quantiles}
\usage{
trimmed_quantile(x, trim = 1L, use_unique = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{trim}{defaults to 1, omitting the min and the max}

\item{use_unique}{logical, if true (defaults), base the quantiles on unique
values, if false, base the quantiles on all data, after trimming.}

\item{...}{other arguments to pass to stats::quantile}
}
\description{
For data X = x1, x2, ..., xn, with order statistics x(1), x(2), ..., x(r) return
the quantiles for a trimmed data set, e.g., X \ {x(1), x(r)} (trim = 1), or 
X \ {x(1), x(2), x(r-1), x(r)} (trim = 2).
}
\examples{
trimmed_quantile(1:100, prob = 1:23 / 24, name = FALSE)

# Warning
# trimmed_quantile(1:100, trim = .3, prob = 1:23 / 24, name = FALSE)

# no warning
trimmed_quantile(1:100, trim = 3, prob = 1:23 / 24, name = FALSE)

}
\author{
Peter DeWitt \email{dewittpe@gmail.com}
}
