% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert.R
\name{insert}
\alias{insert}
\alias{insert,CppSet-method}
\alias{insert,CppUnorderedSet-method}
\alias{insert,CppMultiset-method}
\alias{insert,CppUnorderedMultiset-method}
\alias{insert,CppMap-method}
\alias{insert,CppUnorderedMap-method}
\alias{insert,CppMultimap-method}
\alias{insert,CppUnorderedMultimap-method}
\alias{insert,CppVector-method}
\alias{insert,CppDeque-method}
\alias{insert,CppList-method}
\title{Add elements}
\usage{
insert(x, values, keys = NULL, position = NULL)
}
\arguments{
\item{x}{A CppSet, CppUnorderedSet, CppMultiset, CppUnorderedMultiset, CppMap, CppUnorderedMap, CppMultimap, CppUnorderedMultimap, CppVector, CppDeque, 
or CppList object.}

\item{values}{Values to add to \code{x}.}

\item{keys}{Keys to add to \code{x}. Only relevant for CppMap, CppUnorderedMap, CppMultimap, and CppUnorderedMultimap objects.}

\item{position}{Index at which to insert elements into \code{x}. Only relevant for CppVector, CppDeque, and CppList objects. Indices start at 1.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Add elements to a container by reference.
}
\details{
Existing container values are not overwritten. I.e. inserting a key-value pair into a map that already contains that key preserves the old 
value and discards the new one. Use \link{insert_or_assign} to overwrite values.
}
\examples{
s <- cpp_multiset(4:6)
s
# 4 5 6

insert(s, 6:7)
s
# 4 5 6 6 7

m <- cpp_map(c("hello", "there", "world"), 9:11)
m
# ["hello",9] ["there",10] ["world",11]

insert(m, 12L, "there")
m
# ["hello",9] ["there",10] ["world",11]

}
\seealso{
\link{assign}, \link{emplace}, \link{insert_after}, \link{insert_or_assign}, \link{push}.
}
