% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unordered_multimap.R
\name{cpp_unordered_multimap}
\alias{cpp_unordered_multimap}
\title{Create unordered multimap}
\usage{
cpp_unordered_multimap(keys, values)
}
\arguments{
\item{keys}{An integer, numeric, character, or logical vector.}

\item{values}{An integer, numeric, character, or logical vector.}
}
\value{
Returns a CppUnorderedMultimap object referencing an unordered_multimap in C++.
}
\description{
Create an unordered multimap. Unordered multimaps are key-value pairs with non-unique keys.
}
\details{
Unordered multimaps are associative containers. They do not provide random access through an index. I.e. \code{m[2]} does not return the second 
element.

Unordered means that the container does not enforce elements to be stored in a particular order. This makes unordered multimaps in some applications 
faster than multimaps.

C++ unordered_multimap methods implemented in this package are \link{bucket_count}, \link{clear}, \link{contains}, \link{count}, \link{emplace}, 
\link{empty}, \link{erase}, \link{insert}, \link{load_factor}, \link{max_bucket_count}, \link{max_load_factor}, \link{max_size}, \link{merge}, 
\link{rehash}, \link{reserve}, and \link{size}. The package also adds the \link{==} operator and various helper functions (\link{print}, \link{to_r}, 
\link{type}).

All object-creating methods in this package begin with \code{cpp_} to avoid clashes with functions from other packages, such as \code{utils::stack} and 
\code{base::vector}.
}
\examples{
m <- cpp_unordered_multimap(c("world", "hello", "there", "hello"), 4:7)
m
# ["there",6] ["hello",5] ["hello",7] ["world",4]

print(m, n = 2)
# 

erase(m, "hello")
m
# ["there",6] ["world",4]

contains(m, "there")
# [1] TRUE

}
\seealso{
\link{cpp_map}, \link{cpp_unordered_map}, \link{cpp_multimap}.
}
