% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/draw.R
\name{draw_label}
\alias{draw_label}
\title{Draw a text label or mathematical expression.}
\usage{
draw_label(label, x = 0.5, y = 0.5, hjust = 0.5, vjust = 0.5,
  fontfamily = "", fontface = "plain", colour = "black", size = 14,
  angle = 0, lineheight = 0.9, alpha = 1)
}
\arguments{
\item{label}{String or plotmath expression to be drawn.}

\item{x}{The x location of the label.}

\item{y}{The y location of the label.}

\item{hjust}{Horizontal justification}

\item{vjust}{Vertical justification}

\item{fontfamily}{The font family}

\item{fontface}{The font face ("plain", "bold", etc.)}

\item{colour}{Text color}

\item{size}{Point size of text}

\item{angle}{Angle at which text is drawn}

\item{lineheight}{Line height of text}

\item{alpha}{The alpha value of the text}
}
\description{
This function can draw either a character string or mathematical expression at the given
coordinates. It works both on top of \code{ggdraw} and directly with \code{ggplot}, depending
on which coordinate system is desired (see examples).
}
\details{
By default, the x and y coordinates specify the center of the text box. Set \code{hjust = 0, vjust = 0} to specify
the lower left corner, and other values of \code{hjust} and \code{vjust} for any other relative location you want to
specify.
}
\examples{
p <- ggplot(mtcars, aes(mpg, disp)) + geom_line(colour = "blue") + background_grid(minor='none')
c <- cor.test(mtcars$mpg, mtcars$disp, method='sp')
label <- substitute(paste("Spearman ", rho, " = ", estimate, ", P = ", pvalue),
                    list(estimate = signif(c$estimate, 2), pvalue = signif(c$p.value, 2)))
# adding label via ggdraw, in the ggdraw coordinates
ggdraw(p) + draw_label(label, .7, .9)
# adding label directly to plot, in the data coordinates
p + draw_label(label, 20, 400, hjust = 0, vjust = 0)
}

