% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system.R
\name{system_output}
\alias{system_output}
\title{Run a system command and capture the output.}
\usage{
system_output(cmd, args = character(), env = character(), quiet = FALSE,
  echo = FALSE, ...)
}
\arguments{
\item{cmd}{the command to run.}

\item{args}{a vector of command arguments.}

\item{env}{a named character vector of environment variables.  Will be quoted}

\item{quiet}{if \code{TRUE}, the command output will be echoed.}

\item{echo}{if \code{TRUE}, the command to run will be echoed.}

\item{...}{additional arguments passed to \code{\link[base]{system}}}
}
\value{
command output if the command succeeds, an error will be thrown if
the command fails.
}
\description{
This function automatically quotes both the command and each
argument so they are properly protected from shell expansion.
}
\keyword{internal}

