% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{er}
\alias{er}
\title{Emergency room canine therapy}
\format{
A data frame with 84 observations on the following 53 variables:
\describe{
\item{\code{id}}{Subject ID}
\item{\code{condition}}{Whether the subject saw a \code{Dog} or was in the \code{Control} group}
\item{\code{age}}{Subject's age in years}
\item{\code{gender}}{Subject's self-identified gender}
\item{\code{race}}{Subject's self-identified race}
\item{\code{veteran}}{Is the subject a veteran?}
\item{\code{disabled}}{Is the subject disabled?}
\item{\code{dog_name}}{The name of the therapy dog}
\item{\code{base_pain}}{Subject's self reported pain before the intervention (T0)}
\item{\code{base_depression}}{Subject's self reported depression before the intervention (T0)}
\item{\code{base_anxiety}}{Subject's self reported anxiety before the intervention (T0)}
\item{\code{base_total}}{The sum of the subject's \verb{base_*} scores}
\item{\code{later_pain}}{Subject's self reported pain after the intervention (T1)}
\item{\code{later_depression}}{Subject's self reported depression after the intervention (T1)}
\item{\code{later_anxiety}}{Subject's self reported anxiety after the intervention (T1)}
\item{\code{later_total}}{The sum of the subject's \verb{later_*} scores}
\item{\code{last_pain}}{Subject's self reported pain after the intervention (T2)}
\item{\code{last_depression}}{Subject's self reported depression after the intervention (T2)}
\item{\code{last_anxiety}}{Subject's self reported anxiety after the intervention (T2)}
\item{\code{last_total}}{The sum of the subject's \verb{last_*} scores}
\item{\code{change_pain}}{The change in subject's pain from before the intervention to after}
\item{\code{change_depression}}{The change in subject's depression from before the intervention
to after}
\item{\code{change_anxiety}}{The change in subject's anxiety from before the intervention to after}
\item{\code{change_total}}{The sum of the subject's \verb{change_*} scores}
\item{\code{provider_male}}{Was the health care provider male?}
\item{\code{provider}}{The health care provider's status: either an \verb{Advanced Practitioner},
\code{Resident} physician, or \code{Attending} physician}
\item{\code{heart_rate}}{The subject's heart rate at baseline (T0)}
\item{\code{resp_rate}}{The subject's respiratory rate at baseline (T0)}
\item{\code{sp_o2}}{The subject's SpO2 at baseline (T0)}
\item{\code{bp_syst}}{The subject's systolic blood pressure at baseline (T0)}
\item{\code{bp_diast}}{The subject's diastolic blood pressure at baseline (T0)}
\item{\code{med_given}}{Was the subject given medication prior to the study? (T0)}
\item{\code{mh_none}}{None of the other medical history items were indicated}
\item{\code{mh_asthma}}{Medical history: asthma}
\item{\code{mh_smoker}}{Medical history: smoker}
\item{\code{mh_cad}}{Medical history: coronary artery disease}
\item{\code{mh_diabetes}}{Medical history: diabetes mellitus}
\item{\code{mh_hypertension}}{Medical history: hypertension}
\item{\code{mh_stroke}}{Medical history: prior stroke}
\item{\code{mh_chronic_kidney}}{Medical history: chronic kidney disease}
\item{\code{mh_copd}}{Medical history: chronic obstructive pulmonary disease}
\item{\code{mh_hyperlipidemia}}{Medical history: hyperlipidemia}
\item{\code{mh_hiv}}{Medical history: HIV}
\item{\code{mh_other}}{Medical history: other (write-in)}
\item{\code{ph_adhd}}{Psychiatric history: attention-deficit/hyperactivity disorder}
\item{\code{ph_anxiety}}{Psychiatric history: anxiety}
\item{\code{ph_bipolar}}{Psychiatric history: bipolar}
\item{\code{ph_borderline}}{Psychiatric history: borderline personality disorder}
\item{\code{ph_depression}}{Psychiatric history: depression}
\item{\code{ph_schizophrenia}}{Psychiatric history: schizophrenia}
\item{\code{ph_ptsd}}{Psychiatric history: PTSD}
\item{\code{ph_none}}{None of the other psychiatric history items were indicated}
\item{\code{ph_other}}{Psychiatric history: other (write-in)}
}
}
\usage{
er
}
\description{
Data from: Controlled clinical trial of canine therapy versus usual care to reduce patient
anxiety in the emergency department.
\subsection{Abstract}{
\subsection{Objective}{

Test if therapy dogs can reduce anxiety in emergency department (ED) patients.
}

\subsection{Methods}{

In this controlled clinical trial (NCT03471429), medically stable, adult patients
were approached if the physician believed that the patient had “moderate or greater anxiety.”
Patients were allocated on a 1:1 ratio to either 15 min exposure to a certified therapy dog and
handler (dog), or usual care (control). Patient reported anxiety, pain and depression were
assessed using a 0-10 scale (10=worst). Primary outcome was change in anxiety from baseline (T0)
to 30 min and 90 min after exposure to dog or control (T1 and T2 respectively); secondary
outcomes were pain, depression and frequency of pain medication.
}

\subsection{Results}{

Among 98 patients willing to participate in research, 7 had aversions to dogs, leaving 91 (93\%)
were willing to see a dog; 40 patients were allocated to each group (dog or control). No data
were normally distributed. Median baseline anxiety, pain and depression were similar between
groups. With dog exposure, anxiety decreased significantly from T0 to T1: 6 (IQR 4-9.75) to T1:
2 (0-6) compared with 6 (4-8) to 6 (2.5-8) in controls (P<0.001, for T1, Mann-Whitney U). Dog
exposure was associated with significantly lower anxiety at T2 and a significant overall
treatment effect on two-way repeated measures ANOVA for anxiety, pain and depression. After
exposure, 1/40 in the dog group needed pain medication, versus 7/40 in controls (P=0.056,
Fisher’s).
}

\subsection{Conclusions}{

Exposure to therapy dogs plus handlers significantly reduced anxiety in ED patients.
}

}
}
\references{
Kline, J. A., Fisher, M. A., Pettit, K. L., Linville, C. T., & Beck, A. M. (2019). Controlled
clinical trial of canine therapy versus usual care to reduce patient anxiety in the emergency
department. \emph{PloS One, 14}(1), e0209232. \doi{10.1371/journal.pone.0209232}
}
\keyword{datasets}
