% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly_helpers.R
\name{int_surface_data}
\alias{int_surface_data}
\title{Get hourly data for a single monitor.}
\usage{
int_surface_data(usaf_code, wban_code, year, var = "all")
}
\arguments{
\item{usaf_code}{A character string with a six-digit USAF code for the
weather station.}

\item{wban_code}{A character string with a five-digit WBAN code for the
weather station.}

\item{year}{A four-digit numeric giving the year for which to pull data.}

\item{var}{A character vector listing the weather variables to pull. In
addition quality flag data, choices for main weather variables to pull
include \code{wind_direction}, \code{wind_speed},
\code{ceiling_height}, \code{visibility_distance}, \code{temperature},
\code{temperature_dewpoint} and \code{air_pressure}.}
}
\value{
This function returns the same type of dataframe as that returned
   by the \code{isd} function from the \code{rnoaa} package, but with the
   dataframe limited to the selected weather variables and cleaned a bit more.
}
\description{
Wraps the \code{isd} function from the \code{rnoaa} package and provides
some additional data cleaning.
}
\examples{
\dontrun{
ids <- isd_fips_stations(fips = "12086")$stations
kendall_station <- int_surface_data(usaf_code = ids$usaf[11],
                                    wban_code = ids$wban[11],
                                    year = 1992,
                                    var = c("wind_speed", "temperature"))
head(kendall_station)
}
}
\references{
For more information on this dataset, see
\url{ftp://ftp.ncdc.noaa.gov/pub/data/noaa/ish-format-document.pdf}.
}

